/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.client.models.items;

import java.util.Collections;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;
import thelm.jaopca.api.items.IItemFormSettings;
import thelm.jaopca.api.items.IItemModelFunctionCreator;
import thelm.jaopca.api.items.IMaterialFormItem;
import thelm.jaopca.utils.MiscHelper;

public class JAOPCAItemModelFunctionCreator
implements IItemModelFunctionCreator {
    public static final JAOPCAItemModelFunctionCreator INSTANCE = new JAOPCAItemModelFunctionCreator();

    @Override
    public Pair<Function<ItemStack, ModelResourceLocation>, Set<ModelResourceLocation>> create(IMaterialFormItem item, IItemFormSettings settings) {
        ResourceLocation baseModelLocation = this.getBaseModelLocation(item);
        ModelResourceLocation modelLocation = new ModelResourceLocation(baseModelLocation, "inventory");
        return Pair.of(s -> modelLocation, Collections.singleton(modelLocation));
    }

    public ResourceLocation getBaseModelLocation(IMaterialFormItem materialFormItem) {
        Item item = materialFormItem.toItem();
        ResourceLocation location = item.getRegistryName();
        ResourceLocation location1 = new ResourceLocation(location.func_110624_b(), "blockstates/" + location.func_110623_a() + ".json");
        ResourceLocation location2 = new ResourceLocation(location.func_110624_b(), "models/item/" + location.func_110623_a() + ".json");
        if (MiscHelper.INSTANCE.hasResource(location1) || MiscHelper.INSTANCE.hasResource(location2)) {
            return location;
        }
        return new ResourceLocation(location.func_110624_b(), materialFormItem.getMaterial().getModelType() + '/' + materialFormItem.getForm().getName());
    }
}

