/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.abyssalcraft.recipes;

import com.google.common.collect.Lists;
import com.shinoow.abyssalcraft.api.APIUtils;
import com.shinoow.abyssalcraft.api.AbyssalCraftAPI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeAction;
import thelm.jaopca.utils.MiscHelper;

public class MaterializationRecipeAction
implements IRecipeAction {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object output;
    public final int count;
    public final Object[] input;

    public MaterializationRecipeAction(ResourceLocation key, Object output, int count, Object ... input) {
        this.key = Objects.requireNonNull(key);
        this.output = output;
        this.count = count;
        this.input = input;
    }

    @Override
    public boolean register() {
        Ingredient out = MiscHelper.INSTANCE.getIngredient(this.output);
        if (out == null) {
            throw new IllegalArgumentException("Empty output in recipe " + this.key + ": " + this.output);
        }
        ArrayList inputs = new ArrayList();
        int i = 0;
        while (i < this.input.length) {
            Ingredient ing;
            Object in = this.input[i];
            Integer inc = 1;
            if (++i < this.input.length && this.input[i] instanceof Integer) {
                inc = (Integer)this.input[i];
                ++i;
            }
            if ((ing = MiscHelper.INSTANCE.getIngredient(in)) == null || inc == 0) {
                throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + in);
            }
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            for (ItemStack is : ing.func_193365_a()) {
                if (!APIUtils.isCrystal((ItemStack)is)) continue;
                list.add(MiscHelper.INSTANCE.resizeItemStack(is, inc));
            }
            if (list.isEmpty()) {
                throw new IllegalArgumentException("Non-crystal ingredient in recipe " + this.key + ": " + in);
            }
            inputs.add(list);
        }
        if (inputs.isEmpty()) {
            throw new IllegalArgumentException("Empty ingredients in recipe " + this.key + ": " + Arrays.deepToString(this.input));
        }
        for (List in : Lists.cartesianProduct(inputs)) {
            for (ItemStack stack : out.func_193365_a()) {
                AbyssalCraftAPI.addMaterialization((ItemStack)MiscHelper.INSTANCE.resizeItemStack(stack, this.count), (ItemStack[])in.toArray(new ItemStack[in.size()]));
            }
        }
        return true;
    }
}

