/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.appliedenergistics2;

import appeng.core.AEConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.TreeSet;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import thelm.jaopca.api.config.IDynamicSpecConfig;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.api.modules.JAOPCAModule;
import thelm.jaopca.compat.appliedenergistics2.AppliedEnergistics2Helper;
import thelm.jaopca.utils.MiscHelper;

@JAOPCAModule(modDependencies={"appliedenergistics2"})
public class AppliedEnergistics2CompatModule
implements IModule {
    private static final Set<String> TO_DUST_BLACKLIST = new TreeSet<String>();
    private static Set<String> configToDustBlacklist = new TreeSet<String>();

    @Override
    public String getName() {
        return "appliedenergistics2_compat";
    }

    @Override
    public Set<MaterialType> getMaterialTypes() {
        return EnumSet.allOf(MaterialType.class);
    }

    @Override
    public void defineModuleConfig(IModuleData moduleData, IDynamicSpecConfig config) {
        Collections.addAll(TO_DUST_BLACKLIST, AEConfig.instance().getGrinderOres());
        MiscHelper helper = MiscHelper.INSTANCE;
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.toDustMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have grinder to dust recipes added."), configToDustBlacklist);
    }

    @Override
    public void onInit(IModuleData moduleData, FMLInitializationEvent event) {
        AppliedEnergistics2Helper helper = AppliedEnergistics2Helper.INSTANCE;
        MiscHelper miscHelper = MiscHelper.INSTANCE;
        for (IMaterial material : moduleData.getMaterials()) {
            MaterialType type = material.getType();
            String name = material.getName();
            if (!type.isIngot() || TO_DUST_BLACKLIST.contains(name) || configToDustBlacklist.contains(name)) continue;
            String oreOredict = miscHelper.getOredictName(type.getFormName(), material.getName());
            String dustOredict = miscHelper.getOredictName("dust", material.getName());
            helper.registerGrinderRecipe(miscHelper.getRecipeKey("appliedenergistics2.material_to_dust", material.getName()), oreOredict, dustOredict, 1, 4);
        }
    }
}

