/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.appliedenergistics2.recipes;

import appeng.api.AEApi;
import appeng.api.features.IGrinderRecipeBuilder;
import appeng.api.features.IGrinderRegistry;
import java.util.Objects;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeAction;
import thelm.jaopca.utils.MiscHelper;

public class GrinderRecipeAction
implements IRecipeAction {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object input;
    public final Object output;
    public final int outputCount;
    public final Object secondOutput;
    public final int secondOutputCount;
    public final float secondOutputChance;
    public final Object thirdOutput;
    public final int thirdOutputCount;
    public final float thirdOutputChance;
    public final int turns;

    public GrinderRecipeAction(ResourceLocation key, Object input, Object output, int outputCount, int turns) {
        this(key, input, output, outputCount, ItemStack.field_190927_a, 0, 0.0f, ItemStack.field_190927_a, 0, 0.0f, turns);
    }

    public GrinderRecipeAction(ResourceLocation key, Object input, Object output, int outputCount, Object secondOutput, int secondOutputCount, float secondOutputChance, int turns) {
        this(key, input, output, outputCount, secondOutput, secondOutputCount, secondOutputChance, ItemStack.field_190927_a, 0, 0.0f, turns);
    }

    public GrinderRecipeAction(ResourceLocation key, Object input, Object output, int outputCount, Object secondOutput, int secondOutputCount, float secondOutputChance, Object thirdOutput, int thirdOutputCount, float thirdOutputChance, int turns) {
        this.key = Objects.requireNonNull(key);
        this.input = input;
        this.output = output;
        this.outputCount = outputCount;
        this.secondOutput = secondOutput;
        this.secondOutputCount = secondOutputCount;
        this.secondOutputChance = secondOutputChance;
        this.thirdOutput = thirdOutput;
        this.thirdOutputCount = thirdOutputCount;
        this.thirdOutputChance = thirdOutputChance;
        this.turns = turns;
    }

    @Override
    public boolean register() {
        Ingredient ing = MiscHelper.INSTANCE.getIngredient(this.input);
        if (ing == null) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.input);
        }
        ItemStack stack1 = MiscHelper.INSTANCE.getItemStack(this.output, this.outputCount);
        if (stack1.func_190926_b()) {
            throw new IllegalArgumentException("Empty output in recipe " + this.key + ": " + this.output);
        }
        ItemStack stack2 = MiscHelper.INSTANCE.getItemStack(this.secondOutput, this.secondOutputCount);
        ItemStack stack3 = MiscHelper.INSTANCE.getItemStack(this.thirdOutput, this.thirdOutputCount);
        IGrinderRegistry registry = AEApi.instance().registries().grinder();
        for (ItemStack in : ing.func_193365_a()) {
            IGrinderRecipeBuilder builder = registry.builder().withInput(in).withOutput(stack1).withTurns(this.turns);
            if (!stack2.func_190926_b()) {
                builder.withFirstOptional(stack2, this.secondOutputChance);
            }
            if (!stack3.func_190926_b()) {
                builder.withSecondOptional(stack3, this.thirdOutputChance);
            }
            registry.addRecipe(builder.build());
        }
        return true;
    }
}

