/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.bcoreprocessing.recipes;

import java.util.Objects;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.ndrei.bcoreprocessing.api.recipes.OreProcessingRecipes;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeAction;
import thelm.jaopca.utils.MiscHelper;

public class FluidProcessorRecipeAction
implements IRecipeAction {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object input;
    public final int inputAmount;
    public final Object output;
    public final int outputCount;
    public final Object fluidOutput;
    public final int fluidOutputAmount;
    public final int time;

    public FluidProcessorRecipeAction(ResourceLocation key, Object input, int inputAmount, Object output, int outputCount, Object fluidOutput, int fluidOutputAmount, int time) {
        this.key = Objects.requireNonNull(key);
        this.input = input;
        this.inputAmount = inputAmount;
        this.output = output;
        this.outputCount = outputCount;
        this.fluidOutput = fluidOutput;
        this.fluidOutputAmount = fluidOutputAmount;
        this.time = time;
    }

    @Override
    public boolean register() {
        FluidStack ing = MiscHelper.INSTANCE.getFluidStack(this.input, this.inputAmount);
        if (ing == null) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.input);
        }
        ItemStack itemStack = MiscHelper.INSTANCE.getItemStack(this.output, this.outputCount);
        FluidStack fluidStack = MiscHelper.INSTANCE.getFluidStack(this.fluidOutput, this.fluidOutputAmount);
        if (itemStack.func_190926_b() && fluidStack == null) {
            throw new IllegalArgumentException("Empty outputs in recipe " + this.key + ": " + this.output + ", " + this.fluidOutput);
        }
        OreProcessingRecipes.INSTANCE.getFluidProcessorRecipes().registerSimpleRecipe(ing, itemStack, fluidStack, this.time);
        return true;
    }
}

