/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.crafttweaker;

import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.oredict.IOreDictEntry;
import java.util.TreeMap;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMethod;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.compat.crafttweaker.Form;
import thelm.jaopca.compat.crafttweaker.MaterialForm;
import thelm.jaopca.utils.MiscHelper;

@ZenRegister
@ZenClass(value="mods.jaopca.Material")
public class Material {
    private static final TreeMap<IMaterial, Material> MATERIAL_WRAPPERS = new TreeMap();
    private final IMaterial material;

    public static Material getMaterialWrapper(IMaterial material) {
        return MATERIAL_WRAPPERS.computeIfAbsent(material, Material::new);
    }

    private Material(IMaterial material) {
        this.material = material;
    }

    public IMaterial getInternal() {
        return this.material;
    }

    @ZenGetter(value="name")
    public String getName() {
        return this.material.getName();
    }

    @ZenGetter(value="type")
    public String getType() {
        return this.material.getType().getName();
    }

    @ZenGetter(value="alternativeNames")
    public String[] getAlternativeNames() {
        return this.material.getAlternativeNames().toArray(new String[0]);
    }

    @ZenMethod
    public Material getExtra(int index) {
        return new Material(this.material.getExtra(index));
    }

    @ZenMethod
    public boolean hasExtra(int index) {
        return this.material.hasExtra(index);
    }

    @ZenMethod
    public IOreDictEntry getOreDictEntry(String prefix) {
        return CraftTweakerMC.getOreDict((String)MiscHelper.INSTANCE.getOredictName(prefix, this.material.getName()));
    }

    @ZenMethod
    public IItemStack getItemStack(String prefix, int count) {
        MiscHelper helper = MiscHelper.INSTANCE;
        ItemStack stack = helper.getItemStack(helper.getOredictName(prefix, this.material.getName()), count);
        return CraftTweakerMC.getIItemStack((ItemStack)stack);
    }

    @ZenMethod
    public IItemStack getItemStack(String prefix) {
        return this.getItemStack(prefix, 1);
    }

    @ZenMethod
    public ILiquidStack getLiquidStack(String prefix, int count) {
        MiscHelper helper = MiscHelper.INSTANCE;
        FluidStack stack = helper.getFluidStack(helper.getOredictName(prefix, this.material.getName()), count);
        return CraftTweakerMC.getILiquidStack((FluidStack)stack);
    }

    @ZenMethod
    public MaterialForm getMaterialForm(Form form) {
        if (form.containsMaterial(this)) {
            return MaterialForm.getMaterialFormWrapper(form.getInternal(), this.material);
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Material) {
            return this.material == ((Material)obj).material;
        }
        return false;
    }

    public int hashCode() {
        return this.material.hashCode() + 7;
    }
}

