/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.crafttweaker;

import crafttweaker.annotations.ZenRegister;
import java.util.TreeMap;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMethod;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.compat.crafttweaker.Form;
import thelm.jaopca.compat.crafttweaker.Material;
import thelm.jaopca.forms.FormHandler;
import thelm.jaopca.modules.ModuleHandler;

@ZenRegister
@ZenClass(value="mods.jaopca.Module")
public class Module {
    private static final TreeMap<IModule, Module> MODULE_WRAPPERS = new TreeMap();
    private final IModule module;
    private final IModuleData moduleData;

    public static Module getModuleWrapper(IModule module) {
        return MODULE_WRAPPERS.computeIfAbsent(module, Module::new);
    }

    private Module(IModule module) {
        this.module = module;
        this.moduleData = ModuleHandler.getModuleData(module);
    }

    public IModule getInternal() {
        return this.module;
    }

    @ZenGetter(value="name")
    public String getName() {
        return this.module.getName();
    }

    @ZenGetter(value="materialTypes")
    public String[] getMaterialTypes() {
        return (String[])this.module.getMaterialTypes().stream().map(MaterialType::getName).toArray(String[]::new);
    }

    @ZenGetter(value="materials")
    public Material[] getMaterials() {
        return (Material[])this.moduleData.getMaterials().stream().map(Material::getMaterialWrapper).toArray(Material[]::new);
    }

    @ZenMethod
    public boolean containsMaterial(Material material) {
        return this.moduleData.getMaterials().contains(material.getInternal());
    }

    @ZenGetter(value="forms")
    public Form[] getForms() {
        return (Form[])FormHandler.getForms().stream().filter(f -> f.getModule() == this.module).map(Form::getFormWrapper).toArray(Form[]::new);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Module) {
            return this.module == ((Module)obj).module;
        }
        return false;
    }

    public int hashCode() {
        return this.module.hashCode() + 5;
    }
}

