/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.create;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import java.util.TreeSet;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import thelm.jaopca.api.JAOPCAApi;
import thelm.jaopca.api.config.IDynamicSpecConfig;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.api.modules.JAOPCAModule;
import thelm.jaopca.compat.create.CreateHelper;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;

@JAOPCAModule(modDependencies={"create"})
public class CreateCompatModule
implements IModule {
    private static final Set<String> BLACKLIST = new TreeSet<String>(Arrays.asList("Bismuth", "Brass", "Californium", "Chrome", "Constantan", "Copper", "Electrum", "Gold", "Iron", "Lead", "Mingrade", "Nickel", "Steel", "Thorium", "Tin", "Titanium", "Tungsten", "Uranium", "Zinc", "Zirconium"));
    private static Set<String> configToPlateBlacklist = new TreeSet<String>();

    @Override
    public String getName() {
        return "create_compat";
    }

    @Override
    public Set<MaterialType> getMaterialTypes() {
        return EnumSet.allOf(MaterialType.class);
    }

    @Override
    public void defineModuleConfig(IModuleData moduleData, IDynamicSpecConfig config) {
        MiscHelper helper = MiscHelper.INSTANCE;
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.toPlateMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have press to plate recipes added."), configToPlateBlacklist);
    }

    @Override
    public void onInit(IModuleData moduleData, FMLInitializationEvent event) {
        ApiImpl api = ApiImpl.INSTANCE;
        CreateHelper helper = CreateHelper.INSTANCE;
        MiscHelper miscHelper = MiscHelper.INSTANCE;
        Set<String> oredict = ((JAOPCAApi)api).getOredict();
        for (IMaterial material : moduleData.getMaterials()) {
            MaterialType type = material.getType();
            String name = material.getName();
            if (!type.isIngot() || BLACKLIST.contains(name) || configToPlateBlacklist.contains(name)) continue;
            String materialOredict = miscHelper.getOredictName(type.getFormName(), name);
            String plateOredict = miscHelper.getOredictName("plate", name);
            if (!oredict.contains(plateOredict)) continue;
            helper.registerPressingRecipe(miscHelper.getRecipeKey("create.material_to_plate", name), materialOredict, plateOredict, 1);
        }
    }
}

