/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.create.recipes;

import com.melonstudios.createlegacy.recipe.CrushingRecipes;
import com.melonstudios.createlegacy.util.RecipeEntry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeAction;
import thelm.jaopca.utils.MiscHelper;

public class CrushingRecipeAction
implements IRecipeAction {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object input;
    public final Object[] output;
    public final int time;

    public CrushingRecipeAction(ResourceLocation key, Object input, int time, Object ... output) {
        this.key = Objects.requireNonNull(key);
        this.input = input;
        this.output = output;
        this.time = time;
    }

    @Override
    public boolean register() {
        RecipeEntry[] out;
        Ingredient ing = MiscHelper.INSTANCE.getIngredient(this.input);
        if (ing == null) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.input);
        }
        ArrayList<RecipeEntry> outputs = new ArrayList<RecipeEntry>();
        int i = 0;
        while (i < this.output.length) {
            ItemStack stack;
            out = this.output[i];
            Integer count = 1;
            if (++i < this.output.length && this.output[i] instanceof Integer) {
                count = (Integer)this.output[i];
                ++i;
            }
            Float chance = Float.valueOf(1.0f);
            if (i < this.output.length && this.output[i] instanceof Float) {
                chance = (Float)this.output[i];
                ++i;
            }
            if ((stack = MiscHelper.INSTANCE.getItemStack(out, count)).func_190926_b()) {
                LOGGER.warn("Empty output in recipe {}: {}", (Object)this.key, (Object)out);
                continue;
            }
            outputs.add(RecipeEntry.get((ItemStack)stack, (float)chance.floatValue()));
        }
        if (outputs.isEmpty()) {
            throw new IllegalArgumentException("Empty outputs in recipe " + this.key + ": " + Arrays.deepToString(this.output));
        }
        out = outputs.toArray(new RecipeEntry[outputs.size()]);
        for (ItemStack in : ing.func_193365_a()) {
            CrushingRecipes.addRecipe((ItemStack)in, (int)this.time, (RecipeEntry[])out);
        }
        return true;
    }
}

