/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.enderio;

import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import org.apache.commons.lang3.ArrayUtils;
import thelm.jaopca.api.config.IDynamicSpecConfig;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.api.modules.JAOPCAModule;
import thelm.jaopca.compat.enderio.EnderIOHelper;
import thelm.jaopca.utils.MiscHelper;

@JAOPCAModule(modDependencies={"enderio"})
public class EnderIOModule
implements IModule {
    static final Set<String> BLACKLIST = new TreeSet<String>(Arrays.asList("Adamantine", "Agate", "Alexandrite", "Aluminium", "Aluminum", "Amber", "Amethyst", "Ametrine", "Ammolite", "Apatite", "Aquamarine", "Ardite", "AstralSilver", "AstralStarmetal", "Atlarus", "Bauxite", "Beyrl", "BlackDiamond", "BlueTopaz", "Boron", "Carmot", "Carnelian", "CatsEye", "CertusQuartz", "Ceruclase", "Chaos", "ChargedCertusQuartz", "Chrysoprase", "Cinnibar", "Citrine", "Coal", "Cobalt", "Copper", "Coral", "DeepIron", "Diamond", "Dilithium", "DimensionalShard", "Draconium", "Emerald", "Ender", "EnderBiotite", "EnderEssence", "Fluorite", "Galena", "Garnet", "Gold", "GoldenBeryl", "Heliodor", "Ignatius", "Indicolite", "Infuscolium", "Iolite", "Iridium", "Iron", "Jade", "Jasper", "Kalendrite", "Kunzite", "Kyanite", "Lapis", "Lava", "Lead", "Lemurite", "Lepidolite", "Lithium", "Magnesium", "Malachite", "Midasium", "Mithril", "Moonstone", "Morganite", "NaturalAluminum", "NetherQuartz", "Nickel", "Niter", "Onyx", "Opal", "Orichalcum", "Osmium", "Oureclase", "Pearl", "Peridot", "Platinum", "Prometheum", "Prosperity", "Pyrite", "Pyrope", "Quartz", "QuartzBlack", "Redstone", "RoseQuartz", "Rubracium", "Ruby", "Rutile", "Saltpeter", "Sanguinite", "Sapphire", "ShadowIron", "Sheldonite", "Silver", "Sodalite", "Sphalerite", "Spinel", "Sulfur", "Sunstone", "Tanzanite", "Tektite", "Thorium", "Tin", "Titanium", "Topaz", "Tritanium", "Tungsten", "Turquoise", "Uranium", "VioletSapphire", "Vulcanite", "Vyroxeres", "Yellorium", "Zinc", "Zircon"));
    private Map<IMaterial, IDynamicSpecConfig> configs;

    @Override
    public String getName() {
        return "enderio";
    }

    @Override
    public Multimap<Integer, String> getModuleDependencies() {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        builder.put((Object)0, (Object)"dust");
        builder.put((Object)1, (Object)"dust");
        builder.put((Object)2, (Object)"dust");
        return builder.build();
    }

    @Override
    public Set<MaterialType> getMaterialTypes() {
        return EnumSet.of(MaterialType.INGOT);
    }

    @Override
    public Set<String> getDefaultMaterialBlacklist() {
        return BLACKLIST;
    }

    @Override
    public void defineMaterialConfig(IModuleData moduleData, Map<IMaterial, IDynamicSpecConfig> configs) {
        this.configs = configs;
    }

    @Override
    public void onInit(IModuleData moduleData, FMLInitializationEvent event) {
        EnderIOHelper helper = EnderIOHelper.INSTANCE;
        MiscHelper miscHelper = MiscHelper.INSTANCE;
        for (IMaterial material : moduleData.getMaterials()) {
            String oreOredict = miscHelper.getOredictName("ore", material.getName());
            String dustOredict = miscHelper.getOredictName("dust", material.getName());
            IDynamicSpecConfig config = this.configs.get(material);
            String configByproduct = config.getDefinedString("enderio.byproduct", "minecraft:cobblestone", miscHelper.metaItemPredicate(), "The default byproduct material to output in Ender IO's sagmill.");
            ItemStack byproduct = miscHelper.parseMetaItem(configByproduct);
            Object[] output = new Object[]{dustOredict, 2, Float.valueOf(1.0f), byproduct, 1, Float.valueOf(0.15f)};
            if (material.hasExtra(1)) {
                String extraDustOredict = miscHelper.getOredictName("dust", material.getExtra(1).getName());
                output = ArrayUtils.addAll((Object[])output, (Object[])new Object[]{extraDustOredict, 1, Float.valueOf(0.1f)});
            }
            if (material.hasExtra(2)) {
                String secondExtraDustOredict = miscHelper.getOredictName("dust", material.getExtra(2).getName());
                output = ArrayUtils.addAll((Object[])output, (Object[])new Object[]{secondExtraDustOredict, 1, Float.valueOf(0.05f)});
            }
            helper.registerSagMillRecipe(miscHelper.getRecipeKey("enderio.ore_to_dust", material.getName()), oreOredict, 3600, "multiply_output", "ignore", output);
        }
    }
}

