/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.enderio.recipes;

import com.enderio.core.common.util.stackable.Things;
import crazypants.enderio.base.recipe.IRecipeInput;
import crazypants.enderio.base.recipe.Recipe;
import crazypants.enderio.base.recipe.RecipeBonusType;
import crazypants.enderio.base.recipe.RecipeLevel;
import crazypants.enderio.base.recipe.RecipeOutput;
import crazypants.enderio.base.recipe.ThingsRecipeInput;
import crazypants.enderio.base.recipe.sagmill.SagMillRecipeManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeAction;
import thelm.jaopca.compat.enderio.EnderIOHelper;
import thelm.jaopca.utils.MiscHelper;

public class SagMillRecipeAction
implements IRecipeAction {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object input;
    public final int energy;
    public final RecipeBonusType bonusType;
    public final RecipeLevel level;
    public final Object[] output;

    public SagMillRecipeAction(ResourceLocation key, Object input, int energy, String bonusType, String level, Object ... output) {
        this.key = Objects.requireNonNull(key);
        this.input = input;
        this.energy = energy;
        this.bonusType = Objects.requireNonNull(RecipeBonusType.valueOf((String)bonusType.toUpperCase(Locale.US)));
        this.level = Objects.requireNonNull(RecipeLevel.valueOf((String)level.toUpperCase(Locale.US)));
        this.output = output;
    }

    @Override
    public boolean register() {
        Things ing = EnderIOHelper.INSTANCE.getThings(this.input);
        if (ing.isEmpty()) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.input);
        }
        ArrayList<RecipeOutput> outputs = new ArrayList<RecipeOutput>();
        int i = 0;
        while (i < this.output.length) {
            ItemStack stack;
            Object out = this.output[i];
            Integer count = 1;
            if (++i < this.output.length && this.output[i] instanceof Integer) {
                count = (Integer)this.output[i];
                ++i;
            }
            Float chance = Float.valueOf(1.0f);
            if (i < this.output.length && this.output[i] instanceof Float) {
                chance = (Float)this.output[i];
                ++i;
            }
            if ((stack = MiscHelper.INSTANCE.getItemStack(out, count)).func_190926_b()) {
                LOGGER.warn("Empty output in recipe {}: {}", (Object)this.key, out);
                continue;
            }
            outputs.add(new RecipeOutput(stack, chance.floatValue()));
        }
        if (outputs.isEmpty()) {
            throw new IllegalArgumentException("Empty outputs in recipe " + this.key + ": " + Arrays.deepToString(this.output));
        }
        ThingsRecipeInput in = new ThingsRecipeInput(ing);
        RecipeOutput[] out = outputs.toArray(new RecipeOutput[outputs.size()]);
        SagMillRecipeManager.getInstance().addRecipe(new Recipe((IRecipeInput)in, this.energy, this.bonusType, this.level, out));
        return true;
    }
}

