/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.foundry;

import exter.foundry.api.recipe.matcher.IItemMatcher;
import exter.foundry.api.recipe.matcher.ItemStackMatcher;
import exter.foundry.api.recipe.matcher.OreMatcher;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import thelm.jaopca.api.items.IItemProvider;
import thelm.jaopca.compat.foundry.recipes.AtomizerRecipeAction;
import thelm.jaopca.compat.foundry.recipes.CastingRecipeAction;
import thelm.jaopca.compat.foundry.recipes.CastingTableRecipeAction;
import thelm.jaopca.compat.foundry.recipes.MeltingRecipeAction;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;

public class FoundryHelper {
    public static final FoundryHelper INSTANCE = new FoundryHelper();

    private FoundryHelper() {
    }

    public IItemMatcher getItemMatcher(Object obj, int count) {
        Item item;
        if (obj instanceof Supplier) {
            return this.getItemMatcher(((Supplier)obj).get(), count);
        }
        if (obj instanceof IItemMatcher) {
            return (IItemMatcher)obj;
        }
        if (obj instanceof String) {
            if (ApiImpl.INSTANCE.getOredict().contains(obj)) {
                return new OreMatcher((String)obj, count);
            }
        } else if (obj instanceof ItemStack) {
            ItemStack stack = (ItemStack)obj;
            if (!stack.func_190926_b()) {
                return new ItemStackMatcher(MiscHelper.INSTANCE.resizeItemStack(stack, count));
            }
        } else if (obj instanceof Item) {
            if (obj != Items.field_190931_a) {
                return new ItemStackMatcher(new ItemStack((Item)obj, count, Short.MAX_VALUE));
            }
        } else if (obj instanceof Block) {
            if (obj != Blocks.field_150350_a) {
                return new ItemStackMatcher(new ItemStack(Item.func_150898_a((Block)((Block)obj)), count, Short.MAX_VALUE));
            }
        } else if (obj instanceof IItemProvider && (item = ((IItemProvider)obj).asItem()) != Items.field_190931_a) {
            return new ItemStackMatcher(new ItemStack(item, count, Short.MAX_VALUE));
        }
        return null;
    }

    public boolean registerMeltingRecipe(ResourceLocation key, Object input, int inputCount, Object output, int outputAmount, ToIntFunction<FluidStack> temperature, ToIntFunction<FluidStack> speed) {
        return ApiImpl.INSTANCE.registerRecipe(key, new MeltingRecipeAction(key, input, inputCount, output, outputAmount, temperature, speed));
    }

    public boolean registerCastingRecipe(ResourceLocation key, Object fluidInput, int fluidInputAmount, Object mold, Object itemInput, int itemInputCount, Object output, int outputCount, ToIntFunction<FluidStack> speed) {
        return ApiImpl.INSTANCE.registerRecipe(key, new CastingRecipeAction(key, fluidInput, fluidInputAmount, mold, itemInput, itemInputCount, output, outputCount, speed));
    }

    public boolean registerCastingRecipe(ResourceLocation key, Object fluidInput, int fluidInputAmount, Object mold, Object output, int outputCount, ToIntFunction<FluidStack> speed) {
        return ApiImpl.INSTANCE.registerRecipe(key, new CastingRecipeAction(key, fluidInput, fluidInputAmount, mold, output, outputCount, speed));
    }

    public boolean registerCastingTableRecipe(ResourceLocation key, Object input, int inputAmount, Object output, int outputCount, String type) {
        return ApiImpl.INSTANCE.registerRecipe(key, new CastingTableRecipeAction(key, input, inputAmount, output, outputCount, type));
    }

    public boolean registerAtomizerRecipe(ResourceLocation key, Object input, int inputAmount, Object output, int outputCount) {
        return ApiImpl.INSTANCE.registerRecipe(key, new AtomizerRecipeAction(key, input, inputAmount, output, outputCount));
    }
}

