/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.futurepack.recipes;

import futurepack.api.ItemPredicates;
import futurepack.common.crafting.FPZentrifugeManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeAction;
import thelm.jaopca.compat.futurepack.FuturepackHelper;
import thelm.jaopca.utils.MiscHelper;

public class ZentrifugeRecipeAction
implements IRecipeAction {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object input;
    public final int inputCount;
    public final Object[] output;
    public final int support;
    public final int time;

    public ZentrifugeRecipeAction(ResourceLocation key, Object input, int inputCount, int support, int time, Object ... output) {
        this.key = Objects.requireNonNull(key);
        this.input = input;
        this.inputCount = inputCount;
        this.output = output;
        this.support = support;
        this.time = time;
    }

    @Override
    public boolean register() {
        ItemPredicates ing = FuturepackHelper.INSTANCE.getItemPredicates(this.input, this.inputCount);
        if (ing == null) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.input);
        }
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        int i = 0;
        while (i < this.output.length) {
            ItemStack stack;
            Object out = this.output[i];
            Integer count = 1;
            if (++i < this.output.length && this.output[i] instanceof Integer) {
                count = (Integer)this.output[i];
                ++i;
            }
            if ((stack = MiscHelper.INSTANCE.getItemStack(out, count)).func_190926_b()) {
                LOGGER.warn("Empty output in recipe {}: {}", (Object)this.key, out);
                continue;
            }
            outputs.add(stack);
        }
        if (outputs.isEmpty()) {
            throw new IllegalArgumentException("Empty outputs in recipe " + this.key + ": " + Arrays.deepToString(this.output));
        }
        ItemStack[] outs = outputs.toArray(new ItemStack[outputs.size()]);
        FPZentrifugeManager.addRecipe((ItemPredicates)ing, (ItemStack[])outs, (int)this.support).setTime(this.time);
        return true;
    }
}

