/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.hbm;

import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.hbm.items.ModItems;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import thelm.jaopca.api.JAOPCAApi;
import thelm.jaopca.api.config.IDynamicSpecConfig;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.forms.IFormRequest;
import thelm.jaopca.api.items.IItemInfo;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.api.modules.JAOPCAModule;
import thelm.jaopca.compat.hbm.HBMHelper;
import thelm.jaopca.items.ItemFormType;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;

@JAOPCAModule(modDependencies={"hbm"}, classDependencies={"com.hbm.main.MainRegistry", "api.hbm.block.IConveyorBelt"})
public class HBMModule
implements IModule {
    private static final Set<String> BLACKLIST = new TreeSet<String>(Arrays.asList("Aluminum", "Aluminium", "Beryllium", "CertusQuartz", "Cinnabar", "Coal", "Cobalt", "Copper", "Diamond", "Fluorite", "Gold", "Iron", "Lead", "Lithium", "Niter", "Plutonium", "RareEarth", "Redstone", "Saltpeter", "Schrabidium", "Starmetal", "Sulfur", "Thorium", "Titanium", "Tungsten", "Uranium"));
    private static final Set<String> MODULE_BLACKLIST = new TreeSet<String>(Arrays.asList("Aluminum", "Aluminium", "Beryllium", "CertusQuartz", "Cinnabar", "Coal", "Cobalt", "Copper", "Diamond", "Emerald", "Fluorite", "Gold", "Iron", "Lapis", "Lead", "Lignite", "Lithium", "NetherQuartz", "Niter", "Plutonium", "Quartz", "RareEarth", "Redstone", "Saltpeter", "Schrabidium", "Starmetal", "Sulfur", "Thorium", "Titanium", "Tungsten", "Uranium"));
    private Map<IMaterial, IDynamicSpecConfig> configs;
    private final IForm crystalForm = ApiImpl.INSTANCE.newForm(this, "hbm_crystal", ItemFormType.INSTANCE).setMaterialTypes(MaterialType.ORE).setSecondaryName("hbm:crystal").setDefaultMaterialBlacklist(BLACKLIST);

    public HBMModule() {
        ApiImpl.INSTANCE.registerBlacklistedMaterialNames("Ac227", "Am241", "Am242", "At209", "Au198", "Co60", "Cs137", "Gh336", "I131", "Np237", "Pb209", "Po210", "Pu238", "Pu239", "Pu240", "Pu241", "Ra226", "Sr90", "Tc99", "Th232", "Thorium232", "U233", "U235", "U238", "Xe135");
    }

    @Override
    public String getName() {
        return "hbm";
    }

    @Override
    public Multimap<Integer, String> getModuleDependencies() {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        builder.put((Object)0, (Object)"dust");
        builder.put((Object)1, (Object)"dust");
        return builder.build();
    }

    @Override
    public List<IFormRequest> getFormRequests() {
        return Collections.singletonList(this.crystalForm.toRequest());
    }

    @Override
    public Set<MaterialType> getMaterialTypes() {
        return EnumSet.copyOf(Arrays.asList(MaterialType.ORE));
    }

    @Override
    public Set<String> getDefaultMaterialBlacklist() {
        return BLACKLIST;
    }

    @Override
    public void defineMaterialConfig(IModuleData moduleData, Map<IMaterial, IDynamicSpecConfig> configs) {
        this.configs = configs;
    }

    @Override
    public void onInit(IModuleData moduleData, FMLInitializationEvent event) {
        int count;
        ApiImpl api = ApiImpl.INSTANCE;
        HBMHelper helper = HBMHelper.INSTANCE;
        MiscHelper miscHelper = MiscHelper.INSTANCE;
        ItemFormType itemFormType = ItemFormType.INSTANCE;
        Fluid acid = FluidRegistry.getFluid((String)"acid");
        Item tinyLithium = ModItems.powder_lithium_tiny;
        for (IMaterial material : this.crystalForm.getMaterials()) {
            IItemInfo crystalInfo = itemFormType.getMaterialFormInfo(this.crystalForm, material);
            String crystalOredict = miscHelper.getOredictName("hbm:crystal", material.getName());
            String oreOredict = miscHelper.getOredictName("ore", material.getName());
            String materialOredict = miscHelper.getOredictName(material.getType().getFormName(), material.getName());
            String dustOredict = miscHelper.getOredictName("dust", material.getName());
            String extraDustOredict = miscHelper.getOredictName("dust", material.getExtra(1).getName());
            helper.registerCrystallizerRecipe(miscHelper.getRecipeKey("hbm.ore_to_crystal", material.getName()), oreOredict, acid, 500, crystalInfo, 1);
            ((JAOPCAApi)api).registerSmeltingRecipe(miscHelper.getRecipeKey("hbm.crystal_to_material", material.getName()), crystalOredict, materialOredict, material.getType().isDust() ? 6 : 2, 2.0f);
            count = material.getType().isDust() ? 8 : 3;
            helper.registerShredderRecipe(miscHelper.getRecipeKey("hbm.crystal_to_dust_shredder", material.getName()), crystalOredict, dustOredict, count);
            int n = count = material.getType().isDust() ? 4 : 2;
            if (material.hasExtra(1)) {
                helper.registerCentrifugeRecipe(miscHelper.getRecipeKey("hbm.crystal_to_dust_centrifuge", material.getName()), crystalOredict, dustOredict, count, dustOredict, count, extraDustOredict, 1, tinyLithium, 1);
                continue;
            }
            helper.registerCentrifugeRecipe(miscHelper.getRecipeKey("hbm.crystal_to_dust_centrifuge", material.getName()), crystalOredict, dustOredict, count, dustOredict, count, tinyLithium, 1, tinyLithium, 1);
        }
        for (IMaterial material : Sets.filter(moduleData.getMaterials(), m -> !MODULE_BLACKLIST.contains(m.getName()))) {
            String oreOredict = miscHelper.getOredictName("ore", material.getName());
            String dustOredict = miscHelper.getOredictName("dust", material.getName());
            String extraDustOredict = miscHelper.getOredictName("dust", material.getExtra(1).getName());
            IDynamicSpecConfig config = this.configs.get(material);
            String configByproduct = config.getDefinedString("hbm.byproduct", "minecraft:gravel", miscHelper.metaItemPredicate(), "The default byproduct material to output in HBMNTM's centrifuge.");
            ItemStack byproduct = miscHelper.parseMetaItem(configByproduct);
            count = material.getType().isDust() ? 3 : 1;
            helper.registerCentrifugeRecipe(miscHelper.getRecipeKey("hbm.ore_to_dust_centrifuge", material.getName()), oreOredict, dustOredict, count, dustOredict, count, extraDustOredict, 1, byproduct, 1);
        }
    }
}

