/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.hbm.recipes;

import com.hbm.inventory.AnvilRecipes;
import com.hbm.inventory.RecipesCommon;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeAction;
import thelm.jaopca.compat.hbm.HBMHelper;
import thelm.jaopca.utils.MiscHelper;

public class AnvilConstructionRecipeAction
implements IRecipeAction {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object[] input;
    public final Object[] output;
    public final int tier;

    public AnvilConstructionRecipeAction(ResourceLocation key, Object[] input, Object[] output, int tier) {
        this.key = Objects.requireNonNull(key);
        this.input = input;
        this.output = output;
        this.tier = tier;
    }

    @Override
    public boolean register() {
        ArrayList<RecipesCommon.AStack> inputs = new ArrayList<RecipesCommon.AStack>();
        int i = 0;
        while (i < this.input.length) {
            RecipesCommon.AStack ing;
            Object in = this.input[i];
            Integer count = 1;
            if (++i < this.output.length && this.output[i] instanceof Integer) {
                count = (Integer)this.output[i];
                ++i;
            }
            if ((ing = HBMHelper.INSTANCE.getAStack(in, count)) == null) {
                throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + in);
            }
            inputs.add(ing);
        }
        if (inputs.isEmpty()) {
            throw new IllegalArgumentException("Empty ingredients in recipe " + this.key + ": " + Arrays.deepToString(this.input));
        }
        ArrayList<AnvilRecipes.AnvilOutput> outputs = new ArrayList<AnvilRecipes.AnvilOutput>();
        i = 0;
        while (i < this.output.length) {
            ItemStack stack;
            Object out = this.output[i];
            Integer count = 1;
            if (++i < this.output.length && this.output[i] instanceof Integer) {
                count = (Integer)this.output[i];
                ++i;
            }
            Float chance = Float.valueOf(1.0f);
            if (i < this.output.length && this.output[i] instanceof Float) {
                chance = (Float)this.output[i];
                ++i;
            }
            if ((stack = MiscHelper.INSTANCE.getItemStack(out, count)).func_190926_b()) {
                LOGGER.warn("Empty output in recipe {}: {}", (Object)this.key, out);
                continue;
            }
            outputs.add(new AnvilRecipes.AnvilOutput(stack, chance.floatValue()));
        }
        if (outputs.isEmpty()) {
            throw new IllegalArgumentException("Empty outputs in recipe " + this.key + ": " + Arrays.deepToString(this.output));
        }
        AnvilRecipes.AnvilOutput[] outs = outputs.toArray(new AnvilRecipes.AnvilOutput[outputs.size()]);
        RecipesCommon.AStack[] ins = inputs.toArray(new RecipesCommon.AStack[inputs.size()]);
        AnvilRecipes.AnvilConstructionRecipe recipe = new AnvilRecipes.AnvilConstructionRecipe(ins, outs).setTier(this.tier);
        if (ins.length == 1 && outs.length == 1) {
            recipe.setOverlay(AnvilRecipes.OverlayType.SMITHING);
        } else if (ins.length == 1) {
            recipe.setOverlay(AnvilRecipes.OverlayType.RECYCLING);
        } else if (outs.length == 1) {
            recipe.setOverlay(AnvilRecipes.OverlayType.CONSTRUCTION);
        }
        AnvilRecipes.getConstruction().add(recipe);
        return true;
    }
}

