/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.hbm.recipes;

import com.hbm.inventory.CentrifugeRecipes;
import com.hbm.inventory.RecipesCommon;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeAction;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;

public class CentrifugeRecipeAction
implements IRecipeAction {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object input;
    public final Object[] output;

    public CentrifugeRecipeAction(ResourceLocation key, Object input, Object ... output) {
        this.key = Objects.requireNonNull(key);
        this.input = input;
        this.output = output;
    }

    @Override
    public boolean register() {
        ArrayList<Object> ins = new ArrayList<Object>();
        if (this.input instanceof String) {
            if (!ApiImpl.INSTANCE.getOredict().contains(this.input)) {
                throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.input);
            }
            ins.add(this.input);
        } else {
            Ingredient ing = MiscHelper.INSTANCE.getIngredient(this.input);
            if (ing == null) {
                throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.input);
            }
            for (ItemStack is : ing.func_193365_a()) {
                ins.add(new RecipesCommon.ComparableStack(is).singulize());
            }
        }
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        int i = 0;
        while (i < this.output.length) {
            ItemStack stack;
            Object out = this.output[i];
            Integer count = 1;
            if (++i < this.output.length && this.output[i] instanceof Integer) {
                count = (Integer)this.output[i];
                ++i;
            }
            if ((stack = MiscHelper.INSTANCE.getItemStack(out, count)).func_190926_b()) {
                LOGGER.warn("Empty output in recipe {}: {}", (Object)this.key, out);
                continue;
            }
            outputs.add(stack);
        }
        if (outputs.isEmpty()) {
            throw new IllegalArgumentException("Empty outputs in recipe " + this.key + ": " + Arrays.deepToString(this.output));
        }
        ItemStack[] out = outputs.toArray(new ItemStack[outputs.size()]);
        try {
            Field mapField = CentrifugeRecipes.class.getDeclaredField("recipes");
            mapField.setAccessible(true);
            Map map = (Map)mapField.get(null);
            for (Object e : ins) {
                map.put(e, out);
            }
            return true;
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not access centrifuge recipe map.");
        }
    }
}

