/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.ic2;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import ic2.api.item.IC2Items;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import thelm.jaopca.api.JAOPCAApi;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.forms.IFormRequest;
import thelm.jaopca.api.items.IItemInfo;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.api.modules.JAOPCAModule;
import thelm.jaopca.compat.ic2.IC2Helper;
import thelm.jaopca.items.ItemFormType;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;

@JAOPCAModule(modDependencies={"ic2"})
public class IC2Module
implements IModule {
    private static final Set<String> BLACKLIST = new TreeSet<String>(Arrays.asList("Copper", "Gold", "Iron", "Lead", "Tin", "Silver", "Uranium"));
    private final IForm crushedForm = ApiImpl.INSTANCE.newForm(this, "ic2_crushed", ItemFormType.INSTANCE).setMaterialTypes(MaterialType.INGOT).setSecondaryName("crushed").setDefaultMaterialBlacklist(BLACKLIST);
    private final IForm purifiedCrushedForm = ApiImpl.INSTANCE.newForm(this, "ic2_purified_crushed", ItemFormType.INSTANCE).setMaterialTypes(MaterialType.INGOT).setSecondaryName("crushedPurified").setDefaultMaterialBlacklist(BLACKLIST);
    private final IFormRequest formRequest = ApiImpl.INSTANCE.newFormRequest(this, this.crushedForm, this.purifiedCrushedForm).setGrouped(true);

    @Override
    public String getName() {
        return "ic2";
    }

    @Override
    public Multimap<Integer, String> getModuleDependencies() {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        builder.put((Object)0, (Object)"dust");
        builder.put((Object)0, (Object)"tiny_dust");
        builder.put((Object)1, (Object)"tiny_dust");
        return builder.build();
    }

    @Override
    public List<IFormRequest> getFormRequests() {
        return Collections.singletonList(this.formRequest);
    }

    @Override
    public Set<MaterialType> getMaterialTypes() {
        return EnumSet.of(MaterialType.INGOT);
    }

    @Override
    public Set<String> getDefaultMaterialBlacklist() {
        return BLACKLIST;
    }

    @Override
    public void onInit(IModuleData moduleData, FMLInitializationEvent event) {
        ApiImpl api = ApiImpl.INSTANCE;
        IC2Helper helper = IC2Helper.INSTANCE;
        MiscHelper miscHelper = MiscHelper.INSTANCE;
        ItemFormType itemFormType = ItemFormType.INSTANCE;
        ItemStack stoneDust = IC2Items.getItem((String)"dust", (String)"stone");
        for (IMaterial material : this.crushedForm.getMaterials()) {
            IItemInfo crushedInfo = itemFormType.getMaterialFormInfo(this.crushedForm, material);
            String crushedOredict = miscHelper.getOredictName("crushed", material.getName());
            IItemInfo purifiedCrushedInfo = itemFormType.getMaterialFormInfo(this.purifiedCrushedForm, material);
            String purifiedCrushedOredict = miscHelper.getOredictName("crushedPurified", material.getName());
            String oreOredict = miscHelper.getOredictName("ore", material.getName());
            String tinyDustOredict = miscHelper.getOredictName("dustTiny", material.getName());
            String materialOredict = miscHelper.getOredictName(material.getType().getFormName(), material.getName());
            String dustOredict = miscHelper.getOredictName("dust", material.getName());
            String extraTinyDustOredict = miscHelper.getOredictName("dustTiny", material.getExtra(1).getName());
            helper.registerMaceratorRecipe(miscHelper.getRecipeKey("ic2.ore_to_crushed", material.getName()), oreOredict, 1, crushedInfo, 2);
            helper.registerOreWashingRecipe(miscHelper.getRecipeKey("ic2.crushed_to_purified_crushed", material.getName()), crushedOredict, 1, 1000, purifiedCrushedInfo, 1, tinyDustOredict, 2, stoneDust, 1);
            ((JAOPCAApi)api).registerSmeltingRecipe(miscHelper.getRecipeKey("ic2.crushed_to_material", material.getName()), crushedOredict, materialOredict, 1, 0.5f);
            ((JAOPCAApi)api).registerSmeltingRecipe(miscHelper.getRecipeKey("ic2.purified_crushed_to_material", material.getName()), purifiedCrushedOredict, materialOredict, 1, 0.5f);
            helper.registerMaceratorRecipe(miscHelper.getRecipeKey("ic2.crushed_to_dust_macerator", material.getName()), crushedOredict, 1, dustOredict, 1);
            helper.registerMaceratorRecipe(miscHelper.getRecipeKey("ic2.purified_crushed_to_dust_macerator", material.getName()), purifiedCrushedOredict, 1, dustOredict, 1);
            helper.registerCentrifugeRecipe(miscHelper.getRecipeKey("ic2.crushed_to_dust_centrifuge", material.getName()), crushedOredict, 1, 1500, extraTinyDustOredict, 1, dustOredict, 1, stoneDust, 1);
            helper.registerCentrifugeRecipe(miscHelper.getRecipeKey("ic2.purified_crushed_to_dust_centrifuge", material.getName()), purifiedCrushedOredict, 1, 1500, extraTinyDustOredict, 1, dustOredict, 1);
        }
    }

    @Override
    public Map<String, String> getLegacyRemaps() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"crushed", (Object)"ic2_crushed");
        builder.put((Object)"crushedpurified", (Object)"ic2_purified_crushed");
        builder.put((Object)"purified", (Object)"ic2_purified_crushed");
        return builder.build();
    }
}

