/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.integrateddynamics;

import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import java.util.TreeSet;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.api.modules.JAOPCAModule;
import thelm.jaopca.compat.integrateddynamics.IntegratedDynamicsHelper;
import thelm.jaopca.utils.MiscHelper;

@JAOPCAModule(modDependencies={"integrateddynamics"})
public class IntegratedDynamicsModule
implements IModule {
    static final Set<String> BLACKLIST = new TreeSet<String>(Arrays.asList("Ardite", "Coal", "Cobalt", "Copper", "Dark", "Diamond", "Emerald", "Gold", "Iron", "Lapis", "Lead", "Mithril", "NetherQuartz", "Nickel", "Platinum", "Quartz", "Redstone", "Silver", "Tin"));

    @Override
    public String getName() {
        return "integrateddynamics";
    }

    @Override
    public Multimap<Integer, String> getModuleDependencies() {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        builder.put((Object)0, (Object)"dust");
        return builder.build();
    }

    @Override
    public Set<MaterialType> getMaterialTypes() {
        return EnumSet.of(MaterialType.INGOT);
    }

    @Override
    public Set<String> getDefaultMaterialBlacklist() {
        return BLACKLIST;
    }

    @Override
    public void onInit(IModuleData moduleData, FMLInitializationEvent event) {
        IntegratedDynamicsHelper helper = IntegratedDynamicsHelper.INSTANCE;
        MiscHelper miscHelper = MiscHelper.INSTANCE;
        for (IMaterial material : moduleData.getMaterials()) {
            String oreOredict = miscHelper.getOredictName("ore", material.getName());
            String dustOredict = miscHelper.getOredictName("dust", material.getName());
            helper.registerSqueezerRecipe(miscHelper.getRecipeKey("integrateddynamics.ore_to_dust", material.getName()), oreOredict, new Object[]{dustOredict, 1, Float.valueOf(1.0f), dustOredict, 1, Float.valueOf(0.75f)});
            helper.registerMechanicalSqueezerRecipe(miscHelper.getRecipeKey("integrateddynamics.ore_to_dust_mechanical", material.getName()), oreOredict, new Object[]{dustOredict, 2, Float.valueOf(1.0f), dustOredict, 1, Float.valueOf(0.5f)}, 40);
        }
    }
}

