/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.magneticraft;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import thelm.jaopca.api.config.IDynamicSpecConfig;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.api.modules.JAOPCAModule;
import thelm.jaopca.compat.magneticraft.MagneticraftHelper;
import thelm.jaopca.utils.MiscHelper;

@JAOPCAModule(modDependencies={"magneticraft"}, classDependencies={"com.cout970.magneticraft.api.registries.machines.grinder.IGrinderRecipeManager"})
public class MagneticraftNonIngotModule
implements IModule {
    private static final Set<String> BLACKLIST = new TreeSet<String>(Arrays.asList("Coal", "Diamond", "Emerald", "Galena", "Lapis", "NetherQuartz", "Pyrite", "Quartz", "Redstone", "Sulfur"));
    private Map<IMaterial, IDynamicSpecConfig> configs;

    @Override
    public String getName() {
        return "magneticraft_non_ingot";
    }

    @Override
    public Set<MaterialType> getMaterialTypes() {
        return EnumSet.of(MaterialType.GEM, MaterialType.CRYSTAL, MaterialType.DUST);
    }

    @Override
    public Set<String> getDefaultMaterialBlacklist() {
        return BLACKLIST;
    }

    @Override
    public void defineMaterialConfig(IModuleData moduleData, Map<IMaterial, IDynamicSpecConfig> configs) {
        this.configs = configs;
    }

    @Override
    public void onInit(IModuleData moduleData, FMLInitializationEvent event) {
        MagneticraftHelper helper = MagneticraftHelper.INSTANCE;
        MiscHelper miscHelper = MiscHelper.INSTANCE;
        for (IMaterial material : moduleData.getMaterials()) {
            String oreOredict = miscHelper.getOredictName("ore", material.getName());
            String materialOredict = miscHelper.getOredictName(material.getType().getFormName(), material.getName());
            IDynamicSpecConfig config = this.configs.get(material);
            String configByproduct = config.getDefinedString("magneticraft.grinderByproduct", "minecraft:gravel", miscHelper.metaItemPredicate(), "The default byproduct material to output in Magneticraft's grinder.");
            ItemStack byproduct = miscHelper.parseMetaItem(configByproduct);
            helper.registerGrinderRecipe(miscHelper.getRecipeKey("magneticraft.ore_to_material", material.getName()), oreOredict, materialOredict, material.getType().isCrystalline() ? 2 : 4, byproduct, 1, 0.15f, 50.0f);
        }
    }
}

