/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.magneticraft;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.ToIntFunction;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import thelm.jaopca.api.JAOPCAApi;
import thelm.jaopca.api.config.IDynamicSpecConfig;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.api.modules.JAOPCAModule;
import thelm.jaopca.compat.tconstruct.TConstructHelper;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;

@JAOPCAModule(modDependencies={"magneticraft", "tconstruct"}, classDependencies={"com.cout970.magneticraft.api.registries.machines.grinder.IGrinderRecipeManager"})
public class MagneticraftTConstructModule
implements IModule {
    private static final Set<String> CHUNK_BLACKLIST = new TreeSet<String>(Arrays.asList("Aluminium", "Aluminum", "Cobalt", "Copper", "Galena", "Gold", "Iron", "Lead", "Mithril", "Nickel", "Osmium", "Silver", "Tin", "Tungsten", "Zinc"));
    private static final Set<String> HEAVY_PLATE_BLACKLIST = new TreeSet<String>(Arrays.asList("Copper", "Gold", "Iron", "Lead", "Steel", "Tungsten"));
    private static Set<String> configRockyChunkToMoltenBlacklist = new TreeSet<String>();
    private static Set<String> configChunkToMoltenBlacklist = new TreeSet<String>();
    private static Set<String> configHeavyPlateToMoltenBlacklist = new TreeSet<String>();
    private static boolean jaopcaOnly = false;

    @Override
    public String getName() {
        return "magneticraft_tconstruct";
    }

    @Override
    public Set<MaterialType> getMaterialTypes() {
        return EnumSet.allOf(MaterialType.class);
    }

    @Override
    public void defineModuleConfig(IModuleData moduleData, IDynamicSpecConfig config) {
        MiscHelper helper = MiscHelper.INSTANCE;
        jaopcaOnly = config.getDefinedBoolean("recipes.jaopcaOnly", jaopcaOnly, "Should the module only add recipes for materials with JAOPCA molten fluids.");
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.rockyChunkToMoltenMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have rock chunk melting recipes added."), configRockyChunkToMoltenBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.chunkToMoltenMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have chunk melting recipes added."), configChunkToMoltenBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.heavyPlateToMoltenMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have heavy plate melting recipes added."), configHeavyPlateToMoltenBlacklist);
    }

    @Override
    public void onInit(IModuleData moduleData, FMLInitializationEvent event) {
        ApiImpl api = ApiImpl.INSTANCE;
        TConstructHelper helper = TConstructHelper.INSTANCE;
        MiscHelper miscHelper = MiscHelper.INSTANCE;
        Set<String> oredict = ((JAOPCAApi)api).getOredict();
        Set<IMaterial> moltenMaterials = ((JAOPCAApi)api).getForm("molten").getMaterials();
        ToIntFunction<FluidStack> tempFunction = stack -> stack.getFluid().getTemperature(stack) - 300;
        for (IMaterial material : moduleData.getMaterials()) {
            String heavyPlateOredict;
            String chunkOredict;
            String rockyChunkOredict;
            String moltenName;
            MaterialType type = material.getType();
            String name = material.getName();
            if (!type.isIngot() || jaopcaOnly && !moltenMaterials.contains(material) || !FluidRegistry.isFluidRegistered((String)(moltenName = miscHelper.getFluidName("", name)))) continue;
            if (type == MaterialType.INGOT && !CHUNK_BLACKLIST.contains(name) && !configRockyChunkToMoltenBlacklist.contains(name) && oredict.contains(rockyChunkOredict = miscHelper.getOredictName("rockyChunk", name))) {
                helper.registerMeltingRecipe(miscHelper.getRecipeKey("magneticraft_tconstruct.rocky_chunk_to_molten", name), rockyChunkOredict, moltenName, 288, tempFunction);
            }
            if (type == MaterialType.INGOT && !CHUNK_BLACKLIST.contains(name) && !configChunkToMoltenBlacklist.contains(name) && oredict.contains(chunkOredict = miscHelper.getOredictName("chunk", name))) {
                helper.registerMeltingRecipe(miscHelper.getRecipeKey("magneticraft_tconstruct.chunk_to_molten", name), chunkOredict, moltenName, 288, tempFunction);
            }
            if (HEAVY_PLATE_BLACKLIST.contains(name) || configHeavyPlateToMoltenBlacklist.contains(name) || !oredict.contains(heavyPlateOredict = miscHelper.getOredictName("heavyPlate", name))) continue;
            helper.registerMeltingRecipe(miscHelper.getRecipeKey("magneticraft_tconstruct.heavy_plate_to_molten", name), heavyPlateOredict, moltenName, 576, tempFunction);
        }
    }
}

