/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.magneticraft.recipes;

import com.cout970.magneticraft.api.MagneticraftApi;
import com.cout970.magneticraft.api.registries.machines.sluicebox.ISluiceBoxRecipeManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import kotlin.Pair;
import kotlin.TuplesKt;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeAction;
import thelm.jaopca.utils.MiscHelper;

public class SluiceBoxRecipeAction
implements IRecipeAction {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object input;
    public final Object[] output;

    public SluiceBoxRecipeAction(ResourceLocation key, Object input, Object ... output) {
        this.key = Objects.requireNonNull(key);
        this.input = input;
        this.output = output;
    }

    @Override
    public boolean register() {
        Ingredient ing = MiscHelper.INSTANCE.getIngredient(this.input);
        if (ing == null) {
            throw new IllegalArgumentException("Empty input in recipe " + this.key + ": " + this.input);
        }
        ArrayList<Pair> outputs = new ArrayList<Pair>();
        int i = 0;
        while (i < this.output.length) {
            ItemStack stack;
            Object out = this.output[i];
            Integer count = 1;
            if (++i < this.output.length && this.output[i] instanceof Integer) {
                count = (Integer)this.output[i];
                ++i;
            }
            Float chance = Float.valueOf(1.0f);
            if (i < this.output.length && this.output[i] instanceof Float) {
                chance = (Float)this.output[i];
                ++i;
            }
            if ((stack = MiscHelper.INSTANCE.getItemStack(out, count)).func_190926_b()) {
                LOGGER.warn("Empty output in recipe {}: {}", (Object)this.key, out);
                continue;
            }
            outputs.add(TuplesKt.to((Object)stack, (Object)chance));
        }
        if (outputs.isEmpty()) {
            throw new IllegalArgumentException("Empty outputs in recipe " + this.key + ": " + Arrays.deepToString(this.output));
        }
        ISluiceBoxRecipeManager manager = MagneticraftApi.getSluiceBoxRecipeManager();
        for (ItemStack in : ing.func_193365_a()) {
            manager.registerRecipe(manager.createRecipe(in.func_77946_l(), outputs, false));
        }
        return true;
    }
}

