/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.mekanism;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;
import thelm.jaopca.api.JAOPCAApi;
import thelm.jaopca.api.config.IDynamicSpecConfig;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.api.modules.JAOPCAModule;
import thelm.jaopca.compat.mekanism.MekanismHelper;
import thelm.jaopca.compat.mekanism.MekanismModule;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;

@JAOPCAModule(modDependencies={"mekanism"})
public class MekanismCompatModule
implements IModule {
    private static final Set<String> TO_DUST_BLACKLIST = new TreeSet<String>(Arrays.asList("Aluminium", "Aluminum", "Amber", "Charcoal", "Coal", "Copper", "Diamond", "Draconium", "Emerald", "Gold", "Iridium", "Iron", "Lapis", "Lead", "Malachite", "Mithril", "NetherQuartz", "Nickel", "Osmium", "Peridot", "Platinum", "Quartz", "Redstone", "RefinedGlowstone", "RefinedObsidian", "Ruby", "Sapphire", "Silver", "Steel", "Tanzanite", "Tin", "Topaz", "Uranium"));
    private static final Set<String> TO_CRYSTAL_BLACKLIST = new TreeSet<String>(Arrays.asList("Amber", "Charcoal", "Coal", "Diamond", "Emerald", "Lapis", "NetherQuartz", "Malachite", "Peridot", "Quartz", "Ruby", "Sapphire", "Sulfur", "Tanzanite", "Topaz"));
    private static final Set<String> TO_ORE_BLACKLIST = new TreeSet<String>(Arrays.asList("Aluminium", "Aluminum", "Amber", "Amethyst", "Apatite", "Coal", "Copper", "Diamond", "Draconium", "Emerald", "Gold", "Iridium", "Iron", "Lapis", "Lead", "Malachite", "Mithril", "NetherQuartz", "Nickel", "Osmium", "Peridot", "Platinum", "Quartz", "Redstone", "Ruby", "Sapphire", "Silver", "Steel", "Tanzanite", "Tin", "Topaz", "Uranium"));
    private static Set<String> configToDustBlacklist = new TreeSet<String>();
    private static Set<String> configToCrystalBlacklist = new TreeSet<String>();
    private static Set<String> configToOreBlacklist = new TreeSet<String>();
    private Map<IMaterial, IDynamicSpecConfig> configs;

    @Override
    public String getName() {
        return "mekanism_compat";
    }

    @Override
    public Set<MaterialType> getMaterialTypes() {
        return EnumSet.allOf(MaterialType.class);
    }

    @Override
    public void defineModuleConfig(IModuleData moduleData, IDynamicSpecConfig config) {
        MiscHelper helper = MiscHelper.INSTANCE;
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.toDustMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have crushing to dust recipes added."), configToDustBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.toCrystalMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have enriching to material recipes added."), configToCrystalBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.toOreMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have combining to ore recipes added."), configToOreBlacklist);
    }

    @Override
    public void defineMaterialConfig(IModuleData moduleData, Map<IMaterial, IDynamicSpecConfig> configs) {
        this.configs = configs;
    }

    @Override
    public void onInit(IModuleData moduleData, FMLInitializationEvent event) {
        ApiImpl api = ApiImpl.INSTANCE;
        MekanismHelper helper = MekanismHelper.INSTANCE;
        MiscHelper miscHelper = MiscHelper.INSTANCE;
        Set<String> oredict = ((JAOPCAApi)api).getOredict();
        for (IMaterial material : moduleData.getMaterials()) {
            MaterialType type = material.getType();
            String name = material.getName();
            if (!(type.isDust() || TO_DUST_BLACKLIST.contains(name) || configToDustBlacklist.contains(name))) {
                String materialOredict = miscHelper.getOredictName(type.getFormName(), name);
                String dustOredict = miscHelper.getOredictName("dust", name);
                if (oredict.contains(dustOredict)) {
                    helper.registerCrusherRecipe(miscHelper.getRecipeKey("mekanism.material_to_dust", name), materialOredict, 1, dustOredict, 1);
                }
            }
            if (type.isCrystalline() && !TO_CRYSTAL_BLACKLIST.contains(name) && !configToCrystalBlacklist.contains(name)) {
                String dustOredict = miscHelper.getOredictName("dust", name);
                String materialOredict = miscHelper.getOredictName(type.getFormName(), name);
                if (oredict.contains(dustOredict)) {
                    helper.registerEnrichmentChamberRecipe(miscHelper.getRecipeKey("mekanism.dust_to_material", name), dustOredict, 1, materialOredict, 1);
                }
            }
            if (!type.isOre() || TO_ORE_BLACKLIST.contains(name) || configToOreBlacklist.contains(name)) continue;
            String ingOredict = miscHelper.getOredictName("dust", name);
            String oreOredict = miscHelper.getOredictName("ore", name);
            if (!oredict.contains(ingOredict)) {
                ingOredict = miscHelper.getOredictName(type.getFormName(), name);
            }
            if (!oredict.contains(ingOredict)) continue;
            IDynamicSpecConfig config = this.configs.get(material);
            String configOreBase = config.getDefinedString("mekanism.oreBase", "minecraft:cobblestone", this::isOredictOrItemValid, "The default base to use in Mekanism's Combiner to recreate ores.");
            Object oreBase = this.getOredictOrItem(configOreBase);
            helper.registerCombinerRecipe(miscHelper.getRecipeKey("mekanism.material_to_ore", name), ingOredict, type.isCrystalline() ? 5 : 8, oreBase, 1, oreOredict, 1);
        }
    }

    public boolean isOredictOrItemValid(String s) {
        if (StringUtils.startsWith((CharSequence)s, (CharSequence)"#")) {
            return ApiImpl.INSTANCE.getOredict().contains(s.substring(1));
        }
        return ForgeRegistries.ITEMS.containsKey(new ResourceLocation(s.split("@(?=\\d*$)")[0]));
    }

    public Object getOredictOrItem(String s) {
        if (StringUtils.startsWith((CharSequence)s, (CharSequence)"#")) {
            return s.substring(1);
        }
        return MiscHelper.INSTANCE.parseMetaItem(s);
    }

    static {
        if (Loader.isModLoaded((String)"appliedenergistics2")) {
            Collections.addAll(TO_DUST_BLACKLIST, "CertusQuartz", "ChargedCertusQuartz", "Fluix");
            Collections.addAll(TO_CRYSTAL_BLACKLIST, "CertusQuartz", "Fluix");
        }
        if (Loader.isModLoaded((String)"metallurgy")) {
            Collections.addAll(TO_DUST_BLACKLIST, MekanismModule.METALLURGY_LIST);
            Collections.addAll(TO_ORE_BLACKLIST, MekanismModule.METALLURGY_LIST);
        }
        if (Loader.isModLoaded((String)"mysticalagriculture")) {
            Collections.addAll(TO_ORE_BLACKLIST, "Inferium", "Prosperity");
        }
    }
}

