/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.mekanism;

import java.util.function.Supplier;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import net.minecraft.util.ResourceLocation;
import thelm.jaopca.compat.mekanism.api.gases.IGasProvider;
import thelm.jaopca.compat.mekanism.recipes.ChemicalCrystallizerRecipeAction;
import thelm.jaopca.compat.mekanism.recipes.ChemicalDissolutionChamberRecipeAction;
import thelm.jaopca.compat.mekanism.recipes.ChemicalInjectionChamberRecipeAction;
import thelm.jaopca.compat.mekanism.recipes.ChemicalWasherRecipeAction;
import thelm.jaopca.compat.mekanism.recipes.CombinerRecipeAction;
import thelm.jaopca.compat.mekanism.recipes.CrusherRecipeAction;
import thelm.jaopca.compat.mekanism.recipes.EnrichmentChamberRecipeAction;
import thelm.jaopca.compat.mekanism.recipes.PurificationChamberRecipeAction;
import thelm.jaopca.utils.ApiImpl;

public class MekanismHelper {
    public static final MekanismHelper INSTANCE = new MekanismHelper();

    private MekanismHelper() {
    }

    public GasStack getGasStack(Object obj, int amount) {
        if (obj instanceof Supplier) {
            return this.getGasStack(((Supplier)obj).get(), amount);
        }
        if (obj instanceof GasStack) {
            return this.resizeGasStack((GasStack)obj, amount);
        }
        if (obj instanceof Gas) {
            return new GasStack((Gas)obj, amount);
        }
        if (obj instanceof IGasProvider) {
            return new GasStack(((IGasProvider)obj).asGas(), amount);
        }
        if (obj instanceof String) {
            return new GasStack(GasRegistry.getGas((String)((String)obj)), amount);
        }
        return null;
    }

    public GasStack resizeGasStack(GasStack stack, int amount) {
        if (stack != null) {
            GasStack ret = stack.copy();
            ret.amount = amount;
            return ret;
        }
        return null;
    }

    public boolean registerCrusherRecipe(ResourceLocation key, Object input, int inputCount, Object output, int outputCount) {
        return ApiImpl.INSTANCE.registerRecipe(key, new CrusherRecipeAction(key, input, inputCount, output, outputCount));
    }

    public boolean registerEnrichmentChamberRecipe(ResourceLocation key, Object input, int inputCount, Object output, int outputCount) {
        return ApiImpl.INSTANCE.registerRecipe(key, new EnrichmentChamberRecipeAction(key, input, inputCount, output, outputCount));
    }

    public boolean registerCombinerRecipe(ResourceLocation key, Object input, int inputCount, Object secondInput, int secondInputCount, Object output, int outputCount) {
        return ApiImpl.INSTANCE.registerRecipe(key, new CombinerRecipeAction(key, input, inputCount, secondInput, secondInputCount, output, outputCount));
    }

    public boolean registerChemicalWasherRecipe(ResourceLocation key, Object input, int inputAmount, Object output, int outputAmount) {
        return ApiImpl.INSTANCE.registerRecipe(key, new ChemicalWasherRecipeAction(key, input, inputAmount, output, outputAmount));
    }

    public boolean registerChemicalCrystallizerRecipe(ResourceLocation key, Object input, int inputCount, Object output, int outputCount) {
        return ApiImpl.INSTANCE.registerRecipe(key, new ChemicalCrystallizerRecipeAction(key, input, inputCount, output, outputCount));
    }

    public boolean registerChemicalDissolutionChamberRecipe(ResourceLocation key, Object input, int inputCount, Object output, int outputCount) {
        return ApiImpl.INSTANCE.registerRecipe(key, new ChemicalDissolutionChamberRecipeAction(key, input, inputCount, output, outputCount));
    }

    public boolean registerPurificationChamberRecipe(ResourceLocation key, Object input, int inputCount, Object output, int outputCount) {
        return ApiImpl.INSTANCE.registerRecipe(key, new PurificationChamberRecipeAction(key, input, inputCount, output, outputCount));
    }

    public boolean registerChemicalInjectionChamberRecipe(ResourceLocation key, Object input, int inputCount, Object gasInput, Object output, int outputCount) {
        return ApiImpl.INSTANCE.registerRecipe(key, new ChemicalInjectionChamberRecipeAction(key, input, inputCount, gasInput, output, outputCount));
    }
}

