/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.mekanism.gases;

import com.google.common.collect.TreeBasedTable;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.compat.mekanism.api.gases.IGasFormSettings;
import thelm.jaopca.compat.mekanism.api.gases.IGasFormType;
import thelm.jaopca.compat.mekanism.api.gases.IGasInfo;
import thelm.jaopca.compat.mekanism.api.gases.IMaterialFormGas;
import thelm.jaopca.compat.mekanism.custom.json.GasFormSettingsDeserializer;
import thelm.jaopca.compat.mekanism.gases.GasFormSettings;
import thelm.jaopca.compat.mekanism.gases.GasInfo;
import thelm.jaopca.forms.FormTypeHandler;
import thelm.jaopca.utils.MiscHelper;

public class GasFormType
implements IGasFormType {
    public static final GasFormType INSTANCE = new GasFormType();
    private static final TreeSet<IForm> FORMS = new TreeSet();
    private static final TreeBasedTable<IForm, IMaterial, IMaterialFormGas> GASES = TreeBasedTable.create();
    private static final TreeBasedTable<IForm, IMaterial, IGasInfo> GAS_INFOS = TreeBasedTable.create();
    private static boolean registered = false;

    private GasFormType() {
    }

    public static void init() {
        FormTypeHandler.registerFormType(INSTANCE);
    }

    @Override
    public String getName() {
        return "gas";
    }

    @Override
    public void addForm(IForm form) {
        FORMS.add(form);
    }

    @Override
    public Set<IForm> getForms() {
        return Collections.unmodifiableNavigableSet(FORMS);
    }

    @Override
    public boolean shouldRegister(IForm form, IMaterial material) {
        String fluidName = MiscHelper.INSTANCE.getFluidName(form.getSecondaryName(), material.getName());
        return GasRegistry.getGas((String)fluidName) == null;
    }

    @Override
    public IGasInfo getMaterialFormInfo(IForm form, IMaterial material) {
        IGasInfo info = (IGasInfo)GAS_INFOS.get((Object)form, (Object)material);
        if (info == null && FORMS.contains(form) && form.getMaterials().contains(material)) {
            info = new GasInfo((IMaterialFormGas)GASES.get((Object)form, (Object)material));
            GAS_INFOS.put((Object)form, (Object)material, (Object)info);
        }
        return info;
    }

    @Override
    public IGasFormSettings getNewSettings() {
        return new GasFormSettings();
    }

    @Override
    public GsonBuilder configureGsonBuilder(GsonBuilder builder) {
        return builder;
    }

    @Override
    public IGasFormSettings deserializeSettings(JsonElement jsonElement, JsonDeserializationContext context) {
        return GasFormSettingsDeserializer.INSTANCE.deserialize(jsonElement, context);
    }

    @Override
    public void registerMaterialForms() {
        if (registered) {
            return;
        }
        registered = true;
        for (IForm form : FORMS) {
            IGasFormSettings settings = (IGasFormSettings)form.getSettings();
            for (IMaterial material : form.getMaterials()) {
                IMaterialFormGas materialFormGas = settings.getGasCreator().create(form, material, settings);
                GASES.put((Object)form, (Object)material, (Object)materialFormGas);
                Gas gas = materialFormGas.toGas();
                GasRegistry.register((Gas)gas);
            }
        }
    }

    public static Collection<IMaterialFormGas> getGases() {
        return GASES.values();
    }
}

