/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.mekanism.gases;

import java.util.Optional;
import mekanism.api.gas.Gas;
import net.minecraft.util.ResourceLocation;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.compat.mekanism.api.gases.IGasFormSettings;
import thelm.jaopca.compat.mekanism.api.gases.IMaterialFormGas;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;

public class JAOPCAGas
extends Gas
implements IMaterialFormGas {
    private final IForm form;
    private final IMaterial material;
    protected final IGasFormSettings settings;
    protected boolean isHidden;
    protected Optional<String> translationKey = Optional.empty();

    public JAOPCAGas(IForm form, IMaterial material, IGasFormSettings settings) {
        super(MiscHelper.INSTANCE.getFluidName(form.getSecondaryName(), material.getName()), new ResourceLocation("jaopca", "gas/" + material.getModelType() + '/' + form.getName()));
        this.form = form;
        this.material = material;
        this.settings = settings;
        this.isHidden = settings.getIsHidden();
    }

    @Override
    public IForm getForm() {
        return this.form;
    }

    @Override
    public IMaterial getMaterial() {
        return this.material;
    }

    public boolean isVisible() {
        return !this.isHidden;
    }

    public int getTint() {
        return 0xFF000000 | this.material.getColor();
    }

    public ResourceLocation getIcon() {
        if (MiscHelper.INSTANCE.hasResource(new ResourceLocation("jaopca", "textures/gas/" + this.form.getName() + '.' + this.material.getName() + ".png"))) {
            return new ResourceLocation("jaopca", "gas/" + this.form.getName() + '.' + this.material.getName());
        }
        return super.getIcon();
    }

    public String getTranslationKey() {
        if (!this.translationKey.isPresent()) {
            this.translationKey = Optional.of("gas.jaopca." + MiscHelper.INSTANCE.toLowercaseUnderscore(this.material.getName()));
        }
        return this.translationKey.get();
    }

    public String getLocalizedName() {
        return ApiImpl.INSTANCE.currentLocalizer().localizeMaterialForm("gas.jaopca." + this.form.getName(), this.material, this.getTranslationKey());
    }
}

