/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.mekanism.recipes;

import java.util.Objects;
import mekanism.api.MekanismAPI;
import mekanism.api.gas.GasStack;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeAction;
import thelm.jaopca.compat.mekanism.MekanismHelper;
import thelm.jaopca.utils.MiscHelper;

public class ChemicalInjectionChamberRecipeAction
implements IRecipeAction {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object input;
    public final int inputCount;
    public final Object gasInput;
    public final Object output;
    public final int outputCount;

    public ChemicalInjectionChamberRecipeAction(ResourceLocation key, Object input, int inputCount, Object gasInput, Object output, int outputCount) {
        this.key = Objects.requireNonNull(key);
        this.input = input;
        this.inputCount = inputCount;
        this.gasInput = gasInput;
        this.output = output;
        this.outputCount = outputCount;
    }

    @Override
    public boolean register() {
        Ingredient ing = MiscHelper.INSTANCE.getIngredient(this.input);
        if (ing == null) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.input);
        }
        GasStack gasIng = MekanismHelper.INSTANCE.getGasStack(this.gasInput, 1);
        if (gasIng == null) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.gasInput);
        }
        ItemStack stack = MiscHelper.INSTANCE.getItemStack(this.output, this.outputCount);
        if (stack.func_190926_b()) {
            throw new IllegalArgumentException("Empty output in recipe " + this.key + ": " + this.output);
        }
        for (ItemStack in : ing.func_193365_a()) {
            MekanismAPI.recipeHelper().addChemicalInjectionChamberRecipe(MiscHelper.INSTANCE.resizeItemStack(in, this.inputCount), gasIng.getGas(), stack);
        }
        return true;
    }
}

