/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.mekanism.recipes;

import java.util.Objects;
import mekanism.api.MekanismAPI;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeAction;
import thelm.jaopca.utils.MiscHelper;

public class CombinerRecipeAction
implements IRecipeAction {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object input;
    public final int inputCount;
    public final Object secondInput;
    public final int secondInputCount;
    public final Object output;
    public final int outputCount;

    public CombinerRecipeAction(ResourceLocation key, Object input, int inputCount, Object secondInput, int secondInputCount, Object output, int outputCount) {
        this.key = Objects.requireNonNull(key);
        this.input = input;
        this.inputCount = inputCount;
        this.secondInput = secondInput;
        this.secondInputCount = secondInputCount;
        this.output = output;
        this.outputCount = outputCount;
    }

    @Override
    public boolean register() {
        Ingredient ing = MiscHelper.INSTANCE.getIngredient(this.input);
        if (ing == null) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.input);
        }
        Ingredient secondIng = MiscHelper.INSTANCE.getIngredient(this.secondInput);
        if (secondIng == null) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.secondInput);
        }
        ItemStack stack = MiscHelper.INSTANCE.getItemStack(this.output, this.outputCount);
        if (stack.func_190926_b()) {
            throw new IllegalArgumentException("Empty output in recipe " + this.key + ": " + this.output);
        }
        for (ItemStack in : ing.func_193365_a()) {
            for (ItemStack in2 : secondIng.func_193365_a()) {
                MekanismAPI.recipeHelper().addCombinerRecipe(MiscHelper.INSTANCE.resizeItemStack(in, this.inputCount), MiscHelper.INSTANCE.resizeItemStack(in2, this.secondInputCount), stack);
            }
        }
        return true;
    }
}

