/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.qmd.recipes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import lach_01298.qmd.recipes.QMDRecipes;
import nc.recipe.ingredient.ChanceItemIngredient;
import nc.recipe.ingredient.EmptyFluidIngredient;
import nc.recipe.ingredient.EmptyItemIngredient;
import nc.recipe.ingredient.IFluidIngredient;
import nc.recipe.ingredient.IItemIngredient;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeAction;
import thelm.jaopca.compat.nuclearcraft.NuclearCraftHelper;

public class OreLeacherRecipeAction
implements IRecipeAction {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object itemInput;
    public final int itemInputCount;
    public final Object[] fluidInput;
    public final Object[] output;

    public OreLeacherRecipeAction(ResourceLocation key, Object itemInput, int itemInputCount, Object[] fluidInput, Object[] output) {
        this.key = Objects.requireNonNull(key);
        this.itemInput = itemInput;
        this.itemInputCount = itemInputCount;
        this.fluidInput = fluidInput;
        this.output = output;
    }

    @Override
    public boolean register() {
        IItemIngredient itemIng = NuclearCraftHelper.INSTANCE.getItemIngredient(this.itemInput, this.itemInputCount);
        ArrayList<Object> fluidIngs = new ArrayList<Object>(3);
        int i = 0;
        while (i < this.fluidInput.length) {
            IFluidIngredient ing;
            Object in = this.fluidInput[i];
            Integer amount = 1000;
            if (++i < this.fluidInput.length && this.fluidInput[i] instanceof Integer) {
                amount = (Integer)this.fluidInput[i];
                ++i;
            }
            if ((ing = NuclearCraftHelper.INSTANCE.getFluidIngredient(in, amount)) instanceof EmptyFluidIngredient) {
                throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + in);
            }
            fluidIngs.add(ing);
        }
        if (itemIng instanceof EmptyItemIngredient && fluidIngs.isEmpty()) {
            throw new IllegalArgumentException("Empty ingredients in recipe " + this.key + ": " + this.itemInput + Arrays.toString(this.fluidInput));
        }
        while (fluidIngs.size() < 3) {
            fluidIngs.add(new EmptyFluidIngredient());
        }
        ArrayList<Object> outputs = new ArrayList<Object>(3);
        i = 0;
        while (i < this.output.length) {
            IItemIngredient ing;
            Object out = this.output[i];
            Integer maxCount = 1;
            if (++i < this.output.length && this.output[i] instanceof Integer) {
                maxCount = (Integer)this.output[i];
                ++i;
            }
            Integer chance = 100;
            if (i < this.output.length && this.output[i] instanceof Integer) {
                chance = (Integer)this.output[i];
                ++i;
            }
            Integer minCount = 0;
            if (chance != 100 && i < this.output.length && this.output[i] instanceof Integer) {
                minCount = (Integer)this.output[i];
                ++i;
            }
            if ((ing = NuclearCraftHelper.INSTANCE.getItemIngredient(out, maxCount)) instanceof EmptyItemIngredient) {
                LOGGER.warn("Empty output in recipe {}: {}", (Object)this.key, out);
                continue;
            }
            outputs.add(chance == 100 ? ing : new ChanceItemIngredient(ing, chance.intValue(), minCount.intValue()));
        }
        if (outputs.isEmpty()) {
            throw new IllegalArgumentException("Empty outputs in recipe " + this.key + ": " + Arrays.toString(this.output));
        }
        while (outputs.size() < 3) {
            outputs.add(new EmptyItemIngredient());
        }
        QMDRecipes.ore_leacher.addRecipe(new Object[]{itemIng, fluidIngs.get(0), fluidIngs.get(1), fluidIngs.get(2), outputs.get(0), outputs.get(1), outputs.get(2)});
        return true;
    }
}

