/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.tconstruct;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.ToIntFunction;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import org.apache.commons.lang3.StringUtils;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import thelm.jaopca.api.JAOPCAApi;
import thelm.jaopca.api.config.IDynamicSpecConfig;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.api.modules.JAOPCAModule;
import thelm.jaopca.compat.tconstruct.TConstructHelper;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;

@JAOPCAModule(modDependencies={"tconstruct"})
public class TConstructCompatModule
implements IModule {
    private static final Set<String> BLACKLIST = new TreeSet<String>();
    private static Set<String> configMaterialToMoltenBlacklist = new TreeSet<String>();
    private static Set<String> configBlockToMoltenBlacklist = new TreeSet<String>();
    private static Set<String> configNuggetToMoltenBlacklist = new TreeSet<String>();
    private static Set<String> configDustToMoltenBlacklist = new TreeSet<String>();
    private static Set<String> configPlateToMoltenBlacklist = new TreeSet<String>();
    private static Set<String> configGearToMoltenBlacklist = new TreeSet<String>();
    private static Set<String> configToMaterialBlacklist = new TreeSet<String>();
    private static Set<String> configToBlockBlacklist = new TreeSet<String>();
    private static Set<String> configToNuggetBlacklist = new TreeSet<String>();
    private static Set<String> configToPlateBlacklist = new TreeSet<String>();
    private static Set<String> configToGearBlacklist = new TreeSet<String>();
    private static Set<String> configMaterialCastBlacklist = new TreeSet<String>();
    private static Set<String> configNuggetCastBlacklist = new TreeSet<String>();
    private static Set<String> configPlateCastBlacklist = new TreeSet<String>();
    private static Set<String> configGearCastBlacklist = new TreeSet<String>();
    private static boolean jaopcaOnly = true;

    @Override
    public String getName() {
        return "tconstruct_compat";
    }

    @Override
    public Set<MaterialType> getMaterialTypes() {
        return EnumSet.allOf(MaterialType.class);
    }

    @Override
    public void defineModuleConfig(IModuleData moduleData, IDynamicSpecConfig config) {
        TinkerRegistry.getMaterialIntegrations().stream().filter(mi -> mi.fluid != null).map(mi -> mi.oreSuffix).filter(StringUtils::isNotEmpty).forEach(BLACKLIST::add);
        BLACKLIST.add("Emerald");
        MiscHelper helper = MiscHelper.INSTANCE;
        jaopcaOnly = config.getDefinedBoolean("recipes.jaopcaOnly", jaopcaOnly, "Should the module only add recipes for materials with JAOPCA molten fluids.");
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.materialToMoltenMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have material melting recipes added."), configMaterialToMoltenBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.blockToMoltenMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have block melting recipes added."), configBlockToMoltenBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.nuggetToMoltenMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have nugget melting recipes added."), configNuggetToMoltenBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.dustToMoltenMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have dust melting recipes added."), configDustToMoltenBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.plateToMoltenMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have plate melting recipes added."), configPlateToMoltenBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.gearToMoltenMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have gear melting recipes added."), configGearToMoltenBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.toMaterialMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have material casting recipes added."), configToMaterialBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.toBlockMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have block casting recipes added."), configToBlockBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.toNuggetMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have nugget casting recipes added."), configToNuggetBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.toPlateMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have plate casting recipes added."), configToPlateBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.toGearMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have gear casting recipes added."), configToGearBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.materialCastMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have material cast recipes added."), configMaterialCastBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.nuggetCastMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have nugget cast recipes added."), configNuggetCastBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.materialCastMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have plate cast recipes added."), configPlateCastBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.materialCastMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have gear cast recipes added."), configGearCastBlacklist);
    }

    @Override
    public void onInit(IModuleData moduleData, FMLInitializationEvent event) {
        ApiImpl api = ApiImpl.INSTANCE;
        TConstructHelper helper = TConstructHelper.INSTANCE;
        MiscHelper miscHelper = MiscHelper.INSTANCE;
        Set<String> oredict = ((JAOPCAApi)api).getOredict();
        Set<IMaterial> moltenMaterials = ((JAOPCAApi)api).getForm("molten").getMaterials();
        ToIntFunction<FluidStack> tempFunction = stack -> stack.getFluid().getTemperature(stack) - 300;
        ItemStack ingotCast = TinkerSmeltery.castIngot;
        ItemStack gemCast = TinkerSmeltery.castGem;
        ItemStack nuggetCast = TinkerSmeltery.castNugget;
        ItemStack plateCast = TinkerSmeltery.castPlate;
        ItemStack gearCast = TinkerSmeltery.castGear;
        List castFluids = TinkerSmeltery.castCreationFluids;
        for (IMaterial material : moduleData.getMaterials()) {
            String gearOredict;
            String plateOredict;
            String nuggetOredict;
            int i;
            MaterialType type = material.getType();
            String name = material.getName();
            if (!(type.isDust() || BLACKLIST.contains(name) || jaopcaOnly && !moltenMaterials.contains(material))) {
                int baseAmount;
                String moltenName = miscHelper.getFluidName("", name);
                int n = baseAmount = material.getType().isIngot() ? 144 : 666;
                if (FluidRegistry.isFluidRegistered((String)moltenName)) {
                    String gearOredict2;
                    String plateOredict2;
                    String dustOredict;
                    String nuggetOredict2;
                    String blockOredict;
                    String materialOredict;
                    if (!configMaterialToMoltenBlacklist.contains(name)) {
                        materialOredict = miscHelper.getOredictName(type.getFormName(), name);
                        helper.registerMeltingRecipe(miscHelper.getRecipeKey("tconstruct.material_to_molten", name), materialOredict, moltenName, baseAmount, tempFunction);
                    }
                    if (!configBlockToMoltenBlacklist.contains(name) && oredict.contains(blockOredict = miscHelper.getOredictName("block", name))) {
                        helper.registerMeltingRecipe(miscHelper.getRecipeKey("tconstruct.block_to_molten", name), blockOredict, moltenName, baseAmount * (material.isSmallStorageBlock() ? 4 : 9), tempFunction);
                    }
                    if (!configNuggetToMoltenBlacklist.contains(name) && oredict.contains(nuggetOredict2 = miscHelper.getOredictName("nugget", name))) {
                        helper.registerMeltingRecipe(miscHelper.getRecipeKey("tconstruct.nugget_to_molten", name), nuggetOredict2, moltenName, baseAmount / 9, tempFunction);
                    }
                    if (!configDustToMoltenBlacklist.contains(name) && oredict.contains(dustOredict = miscHelper.getOredictName("dust", name))) {
                        helper.registerMeltingRecipe(miscHelper.getRecipeKey("tconstruct.dust_to_molten", name), dustOredict, moltenName, baseAmount, tempFunction);
                    }
                    if (!configPlateToMoltenBlacklist.contains(name) && oredict.contains(plateOredict2 = miscHelper.getOredictName("plate", name))) {
                        helper.registerMeltingRecipe(miscHelper.getRecipeKey("tconstruct.plate_to_molten", name), plateOredict2, moltenName, baseAmount, tempFunction);
                    }
                    if (!configGearToMoltenBlacklist.contains(name) && oredict.contains(gearOredict2 = miscHelper.getOredictName("gear", name))) {
                        helper.registerMeltingRecipe(miscHelper.getRecipeKey("tconstruct.gear_to_molten", name), gearOredict2, moltenName, baseAmount * 4, tempFunction);
                    }
                    if (!configToMaterialBlacklist.contains(name)) {
                        materialOredict = miscHelper.getOredictName(type.getFormName(), name);
                        helper.registerTableCastingRecipe(miscHelper.getRecipeKey("tconstruct.molten_to_material", name), type.isIngot() ? ingotCast : gemCast, moltenName, baseAmount, materialOredict, tempFunction, false, false);
                    }
                    if (!configToBlockBlacklist.contains(name) && oredict.contains(blockOredict = miscHelper.getOredictName("block", name))) {
                        helper.registerBasinCastingRecipe(miscHelper.getRecipeKey("tconstruct.molten_to_block", name), null, moltenName, baseAmount * (material.isSmallStorageBlock() ? 4 : 9), blockOredict, tempFunction, false, false);
                    }
                    if (!configToNuggetBlacklist.contains(name) && oredict.contains(nuggetOredict2 = miscHelper.getOredictName("nugget", name))) {
                        helper.registerTableCastingRecipe(miscHelper.getRecipeKey("tconstruct.molten_to_nugget", name), nuggetCast, moltenName, baseAmount / 9, nuggetOredict2, tempFunction, false, false);
                    }
                    if (!configToPlateBlacklist.contains(name) && oredict.contains(plateOredict2 = miscHelper.getOredictName("plate", name))) {
                        helper.registerTableCastingRecipe(miscHelper.getRecipeKey("tconstruct.molten_to_plate", name), plateCast, moltenName, baseAmount, plateOredict2, tempFunction, false, false);
                    }
                    if (!configToGearBlacklist.contains(name) && oredict.contains(gearOredict2 = miscHelper.getOredictName("gear", name))) {
                        helper.registerTableCastingRecipe(miscHelper.getRecipeKey("tconstruct.molten_to_gear", name), gearCast, moltenName, baseAmount * 4, gearOredict2, tempFunction, false, false);
                    }
                }
            }
            if (!(type.isDust() || BLACKLIST.contains(name) || configMaterialCastBlacklist.contains(name))) {
                String materialOredict = miscHelper.getOredictName(type.getFormName(), name);
                if (type.isIngot()) {
                    i = 0;
                    for (FluidStack stack2 : castFluids) {
                        helper.registerTableCastingRecipe(miscHelper.getRecipeKey("tconstruct.material_cast_" + i++, name), materialOredict, stack2, stack2.amount, ingotCast, tempFunction, true, true);
                    }
                } else {
                    i = 0;
                    for (FluidStack stack2 : castFluids) {
                        helper.registerTableCastingRecipe(miscHelper.getRecipeKey("tconstruct.material_cast_" + i++, name), materialOredict, stack2, stack2.amount, gemCast, tempFunction, true, true);
                    }
                }
            }
            if (!type.isDust() && !BLACKLIST.contains(name) && !configNuggetCastBlacklist.contains(name) && oredict.contains(nuggetOredict = miscHelper.getOredictName("nugget", name))) {
                i = 0;
                for (FluidStack stack2 : castFluids) {
                    helper.registerTableCastingRecipe(miscHelper.getRecipeKey("tconstruct.nugget_cast_" + i++, name), nuggetOredict, stack2, stack2.amount, nuggetCast, tempFunction, true, true);
                }
            }
            if (!type.isDust() && !BLACKLIST.contains(name) && !configPlateCastBlacklist.contains(name) && oredict.contains(plateOredict = miscHelper.getOredictName("plate", name))) {
                i = 0;
                for (FluidStack stack2 : castFluids) {
                    helper.registerTableCastingRecipe(miscHelper.getRecipeKey("tconstruct.plate_cast_" + i++, name), plateOredict, stack2, stack2.amount, plateCast, tempFunction, true, true);
                }
            }
            if (type.isDust() || BLACKLIST.contains(name) || configGearCastBlacklist.contains(name) || !oredict.contains(gearOredict = miscHelper.getOredictName("gear", name))) continue;
            i = 0;
            for (FluidStack stack2 : castFluids) {
                helper.registerTableCastingRecipe(miscHelper.getRecipeKey("tconstruct.gear_cast_" + i++, name), gearOredict, stack2, stack2.amount, gearCast, tempFunction, true, true);
            }
        }
    }
}

