/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.tconstruct;

import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.util.RecipeMatch;
import thelm.jaopca.api.items.IItemProvider;
import thelm.jaopca.compat.tconstruct.recipes.BasinCastingRecipeAction;
import thelm.jaopca.compat.tconstruct.recipes.MeltingRecipeAction;
import thelm.jaopca.compat.tconstruct.recipes.TableCastingRecipeAction;
import thelm.jaopca.utils.ApiImpl;

public class TConstructHelper {
    public static final TConstructHelper INSTANCE = new TConstructHelper();

    private TConstructHelper() {
    }

    public RecipeMatch getRecipeMatch(Object obj, int count, int matched) {
        Item item;
        if (obj instanceof Supplier) {
            return this.getRecipeMatch(((Supplier)obj).get(), count, matched);
        }
        if (obj instanceof RecipeMatch) {
            return (RecipeMatch)obj;
        }
        if (obj instanceof String) {
            if (ApiImpl.INSTANCE.getOredict().contains(obj)) {
                return RecipeMatch.of((String)((String)obj), (int)count, (int)matched);
            }
        } else if (obj instanceof ItemStack) {
            ItemStack stack = (ItemStack)obj;
            if (!stack.func_190926_b()) {
                return RecipeMatch.of((ItemStack)((ItemStack)obj), (int)count, (int)matched);
            }
        } else if (obj instanceof Item) {
            if (obj != Items.field_190931_a) {
                return RecipeMatch.of((Item)((Item)obj), (int)count, (int)matched);
            }
        } else if (obj instanceof Block) {
            if (obj != Blocks.field_150350_a) {
                return RecipeMatch.of((Item)Item.func_150898_a((Block)((Block)obj)), (int)count, (int)matched);
            }
        } else if (obj instanceof IItemProvider && (item = ((IItemProvider)obj).asItem()) != Items.field_190931_a) {
            return RecipeMatch.of((Item)item, (int)count, (int)matched);
        }
        return null;
    }

    public boolean registerMeltingRecipe(ResourceLocation key, Object input, Object output, int outputAmount, ToIntFunction<FluidStack> temperature) {
        return ApiImpl.INSTANCE.registerRecipe(key, new MeltingRecipeAction(key, input, output, outputAmount, temperature));
    }

    public boolean registerTableCastingRecipe(ResourceLocation key, Object cast, Object input, int inputAmount, Object output, ToIntFunction<FluidStack> time, boolean consumeCast, boolean switchSlots) {
        return ApiImpl.INSTANCE.registerRecipe(key, new TableCastingRecipeAction(key, cast, input, inputAmount, output, time, consumeCast, switchSlots));
    }

    public boolean registerBasinCastingRecipe(ResourceLocation key, Object cast, Object input, int inputAmount, Object output, ToIntFunction<FluidStack> time, boolean consumeCast, boolean switchSlots) {
        return ApiImpl.INSTANCE.registerRecipe(key, new BasinCastingRecipeAction(key, cast, input, inputAmount, output, time, consumeCast, switchSlots));
    }
}

