/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.techreborn;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.oredict.OreDictionary;
import techreborn.items.ingredients.ItemDusts;
import thelm.jaopca.api.JAOPCAApi;
import thelm.jaopca.api.config.IDynamicSpecConfig;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.api.modules.JAOPCAModule;
import thelm.jaopca.compat.techreborn.TechRebornHelper;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;

@JAOPCAModule(modDependencies={"techreborn"})
public class TechRebornCompatModule
implements IModule {
    private static final Set<String> TO_CRYSTAL_BLACKLIST = new TreeSet<String>(Arrays.asList("Amethyst", "Apatite", "CertusQuartz", "Diamond", "Emerald", "Malachite", "Peridot", "RedGarnet", "Ruby", "Sapphire", "Tanzanite", "Topaz", "YellowGarnet"));
    private static Set<String> configMaterialToDustBlacklist = new TreeSet<String>();
    private static Set<String> configPlateToDustBlacklist = new TreeSet<String>();
    private static Set<String> configBlockToDustBlacklist = new TreeSet<String>();
    private static Set<String> configCrystalToPlateBlacklist = new TreeSet<String>();
    private static Set<String> configDustToPlateBlacklist = new TreeSet<String>();
    private static Set<String> configToCrystalBlacklist = new TreeSet<String>();

    @Override
    public String getName() {
        return "techreborn_compat";
    }

    @Override
    public Set<MaterialType> getMaterialTypes() {
        return EnumSet.allOf(MaterialType.class);
    }

    @Override
    public void defineModuleConfig(IModuleData moduleData, IDynamicSpecConfig config) {
        MiscHelper helper = MiscHelper.INSTANCE;
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.materialToDustMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have grinder material to dust recipes added."), configMaterialToDustBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.plateToDustMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have grinder plate to dust recipes added."), configPlateToDustBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.blockToDustMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have grinder block to dust recipes added."), configBlockToDustBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.crystalToPlateMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have compressor material to plate recipes added."), configCrystalToPlateBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.dustToPlateMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have compressor dust to plate recipes added."), configDustToPlateBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.toCrystalMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have implosion compressor to material recipes added."), configToCrystalBlacklist);
    }

    @Override
    public void onInit(IModuleData moduleData, FMLInitializationEvent event) {
        ApiImpl api = ApiImpl.INSTANCE;
        TechRebornHelper helper = TechRebornHelper.INSTANCE;
        MiscHelper miscHelper = MiscHelper.INSTANCE;
        Set<String> oredict = ((JAOPCAApi)api).getOredict();
        ItemStack darkAshes = ItemDusts.getDustByName((String)"dark_ashes", (int)1);
        for (IMaterial material : moduleData.getMaterials()) {
            String dustOredict;
            String plateOredict;
            String dustOredict2;
            String materialOredict;
            MaterialType type = material.getType();
            String name = material.getName();
            if (!type.isDust() && !configMaterialToDustBlacklist.contains(name)) {
                materialOredict = miscHelper.getOredictName(type.getFormName(), name);
                dustOredict2 = miscHelper.getOredictName("dust", name);
                if (oredict.contains(dustOredict2) && !this.containsTechRebornItem(dustOredict2)) {
                    helper.registerGrinderRecipe(miscHelper.getRecipeKey("techreborn.material_to_dust", name), materialOredict, 1, dustOredict2, 1, 300, 2);
                }
            }
            if (!configPlateToDustBlacklist.contains(name)) {
                String plateOredict2 = miscHelper.getOredictName("plate", name);
                dustOredict2 = miscHelper.getOredictName("dust", name);
                if (oredict.contains(plateOredict2) && oredict.contains(dustOredict2) && !this.containsTechRebornItem(dustOredict2)) {
                    helper.registerGrinderRecipe(miscHelper.getRecipeKey("techreborn.plate_to_dust", name), plateOredict2, 1, dustOredict2, 1, 300, 2);
                }
            }
            if (!configBlockToDustBlacklist.contains(name)) {
                String blockOredict = miscHelper.getOredictName("block", name);
                dustOredict2 = miscHelper.getOredictName("dust", name);
                if (oredict.contains(blockOredict) && oredict.contains(dustOredict2) && !this.containsTechRebornItem(dustOredict2)) {
                    helper.registerGrinderRecipe(miscHelper.getRecipeKey("techreborn.block_to_dust", name), blockOredict, 1, dustOredict2, material.isSmallStorageBlock() ? 4 : 9, 300, 2);
                }
            }
            if (type.isCrystalline() && !configCrystalToPlateBlacklist.contains(name)) {
                materialOredict = miscHelper.getOredictName(type.getFormName(), name);
                plateOredict = miscHelper.getOredictName("plate", name);
                if (oredict.contains(plateOredict) && !this.containsTechRebornItem(plateOredict)) {
                    helper.registerCompressorRecipe(miscHelper.getRecipeKey("techreborn.material_to_plate", name), materialOredict, 1, plateOredict, 1, 400, 2);
                }
            }
            if (!type.isIngot() && !configDustToPlateBlacklist.contains(name)) {
                dustOredict = miscHelper.getOredictName("dust", name);
                plateOredict = miscHelper.getOredictName("plate", name);
                if (oredict.contains(dustOredict) && oredict.contains(plateOredict) && (type.isDust() || !this.containsTechRebornItem(plateOredict))) {
                    helper.registerCompressorRecipe(miscHelper.getRecipeKey("techreborn.dust_to_plate", name), dustOredict, 1, plateOredict, 1, 400, 2);
                }
            }
            if (!type.isCrystalline() || TO_CRYSTAL_BLACKLIST.contains(name) || configToCrystalBlacklist.contains(name)) continue;
            dustOredict = miscHelper.getOredictName("dust", name);
            String materialOredict2 = miscHelper.getOredictName(type.getFormName(), name);
            if (!oredict.contains(dustOredict)) continue;
            helper.registerImplosionCompressorRecipe(miscHelper.getRecipeKey("techreborn.dust_to_material", name), new Object[]{dustOredict, 4, Blocks.field_150335_W, 16}, new Object[]{materialOredict2, 3, darkAshes, 12}, 20, 32);
        }
    }

    public boolean containsTechRebornItem(String oredict) {
        return OreDictionary.getOres((String)oredict, (boolean)false).stream().anyMatch(s -> s.func_77973_b().getRegistryName().func_110624_b().equals("techreborn"));
    }
}

