/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.techreborn;

import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Set;
import java.util.TreeSet;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import org.apache.commons.lang3.ArrayUtils;
import techreborn.init.ModFluids;
import thelm.jaopca.api.config.IDynamicSpecConfig;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.api.modules.JAOPCAModule;
import thelm.jaopca.compat.techreborn.TechRebornHelper;
import thelm.jaopca.compat.techreborn.TechRebornIndustrialIngotModule;
import thelm.jaopca.utils.MiscHelper;

@JAOPCAModule(modDependencies={"techreborn"})
public class TechRebornIndustrialCrystalModule
implements IModule {
    private static Set<String> configWaterBlacklist = new TreeSet<String>();
    private static Set<String> configMercuryBlacklist = new TreeSet<String>();

    @Override
    public String getName() {
        return "techreborn_industrial_crystal";
    }

    @Override
    public Multimap<Integer, String> getModuleDependencies() {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        builder.put((Object)0, (Object)"small_dust");
        builder.put((Object)1, (Object)"small_dust");
        return builder.build();
    }

    @Override
    public Set<MaterialType> getMaterialTypes() {
        return EnumSet.of(MaterialType.GEM, MaterialType.CRYSTAL);
    }

    @Override
    public Set<String> getDefaultMaterialBlacklist() {
        return TechRebornIndustrialIngotModule.BLACKLIST;
    }

    @Override
    public void defineModuleConfig(IModuleData moduleData, IDynamicSpecConfig config) {
        MiscHelper helper = MiscHelper.INSTANCE;
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.waterMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have water industrial grinder recipes added."), configWaterBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.mercuryMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have mercury industrial grinder recipes added."), configMercuryBlacklist);
    }

    @Override
    public void onInit(IModuleData moduleData, FMLInitializationEvent event) {
        TechRebornHelper helper = TechRebornHelper.INSTANCE;
        MiscHelper miscHelper = MiscHelper.INSTANCE;
        for (IMaterial material : moduleData.getMaterials()) {
            Object[] output;
            String oreOredict = miscHelper.getOredictName("ore", material.getName());
            String materialOredict = miscHelper.getOredictName(material.getType().getFormName(), material.getName());
            String smallDustOredict = miscHelper.getOredictName("dustSmall", material.getName());
            String extraSmallDustOredict = miscHelper.getOredictName("dustSmall", material.getExtra(1).getName());
            if (!configWaterBlacklist.contains(material.getName())) {
                output = new Object[]{materialOredict, 1, smallDustOredict, 6};
                if (material.hasExtra(1)) {
                    output = ArrayUtils.addAll((Object[])output, (Object[])new Object[]{extraSmallDustOredict, 2});
                }
                helper.registerIndustrialGrinderRecipe(miscHelper.getRecipeKey("techreborn.ore_to_material_water", material.getName()), oreOredict, 1, FluidRegistry.WATER, 1000, 100, 64, output);
            }
            if (configMercuryBlacklist.contains(material.getName())) continue;
            output = new Object[]{materialOredict, 2, smallDustOredict, 3};
            if (material.hasExtra(1)) {
                output = ArrayUtils.addAll((Object[])output, (Object[])new Object[]{extraSmallDustOredict, 2});
            }
            helper.registerIndustrialGrinderRecipe(miscHelper.getRecipeKey("techreborn.ore_to_material_mercury", material.getName()), oreOredict, 1, ModFluids.MERCURY, 1000, 100, 64, output);
        }
    }
}

