/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.techreborn.recipes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import reborncore.api.praescriptum.ingredients.input.InputIngredient;
import reborncore.api.praescriptum.ingredients.input.ItemStackInputIngredient;
import reborncore.api.praescriptum.ingredients.input.OreDictionaryInputIngredient;
import techreborn.api.recipe.Recipes;
import thelm.jaopca.api.recipes.IRecipeAction;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;

public class CompressorRecipeAction
implements IRecipeAction {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object input;
    public final int inputCount;
    public final Object output;
    public final int outputCount;
    public final int time;
    public final int energy;

    public CompressorRecipeAction(ResourceLocation key, Object input, int inputCount, Object output, int outputCount, int time, int energy) {
        this.key = Objects.requireNonNull(key);
        this.input = input;
        this.inputCount = inputCount;
        this.output = output;
        this.outputCount = outputCount;
        this.time = time;
        this.energy = energy;
    }

    @Override
    public boolean register() {
        ArrayList<Object> ins = new ArrayList<Object>();
        if (this.input instanceof String) {
            if (!ApiImpl.INSTANCE.getOredict().contains(this.input)) {
                throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.input);
            }
            ins.add(OreDictionaryInputIngredient.of((String)((String)this.input), (int)this.inputCount));
        } else {
            Ingredient ing = MiscHelper.INSTANCE.getIngredient(this.input);
            if (ing == null) {
                throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.input);
            }
            for (ItemStack is : ing.func_193365_a()) {
                ins.add(ItemStackInputIngredient.of((ItemStack)MiscHelper.INSTANCE.resizeItemStack(is, this.inputCount)));
            }
        }
        ItemStack stack = MiscHelper.INSTANCE.getItemStack(this.output, this.outputCount);
        if (stack.func_190926_b()) {
            throw new IllegalArgumentException("Empty output in recipe " + this.key + ": " + this.output);
        }
        for (InputIngredient inputIngredient : ins) {
            Recipes.compressor.createRecipe().withInput(Collections.singleton(inputIngredient)).withOutput(stack).withOperationDuration(this.time).withEnergyCostPerTick(this.energy).register();
        }
        return true;
    }
}

