/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.teslathingies;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.ndrei.teslapoweredthingies.items.TeslifiedObsidian;
import org.apache.commons.lang3.ArrayUtils;
import thelm.jaopca.api.config.IDynamicSpecConfig;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.forms.IFormRequest;
import thelm.jaopca.api.items.IItemInfo;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.api.modules.JAOPCAModule;
import thelm.jaopca.compat.teslathingies.TeslaThingiesHelper;
import thelm.jaopca.items.ItemFormType;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;

@JAOPCAModule(modDependencies={"teslathingies"})
public class TeslaThingiesModule
implements IModule {
    public static final Set<String> BLACKLIST = new TreeSet<String>(Arrays.asList("Iron", "Gold", "Coal", "Diamond", "Emerald", "Lapis", "Redstone", "Adamantine", "Antimony", "Aquarium", "Bismuth", "Brass", "Bronze", "Coldiron", "Copper", "Cupronickel", "Electrum", "Invar", "Lead", "Mercury", "Mithril", "Nickel", "Pewter", "Platinum", "Silver", "Starsteel", "Tin", "Zinc", "Aluminium", "AluminiumBrass", "Cadmium", "GalvanizedSteel", "Iridium", "Magnesium", "Manganese", "Nichrome", "Osmium", "Plutonium", "Rutile", "StainlessSteel", "Tantalum", "Titanium", "Tungsten", "Uranium", "Zirconium"));
    private final IForm teslaLumpForm = ApiImpl.INSTANCE.newForm(this, "teslathingies_tesla_lump", ItemFormType.INSTANCE).setMaterialTypes(MaterialType.ORE).setSecondaryName("teslaLump").setDefaultMaterialBlacklist(BLACKLIST);
    private final IForm augmentedLumpForm = ApiImpl.INSTANCE.newForm(this, "teslathingies_augmented_lump", ItemFormType.INSTANCE).setMaterialTypes(MaterialType.ORE).setSecondaryName("augmentedLump").setDefaultMaterialBlacklist(BLACKLIST);
    private final IFormRequest formRequest = ApiImpl.INSTANCE.newFormRequest(this, this.teslaLumpForm, this.augmentedLumpForm).setGrouped(true);
    private Map<IMaterial, IDynamicSpecConfig> configs;

    @Override
    public String getName() {
        return "teslathingies";
    }

    @Override
    public Multimap<Integer, String> getModuleDependencies() {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        builder.put((Object)0, (Object)"dust");
        builder.put((Object)1, (Object)"dust");
        builder.put((Object)2, (Object)"dust");
        return builder.build();
    }

    @Override
    public List<IFormRequest> getFormRequests() {
        return Collections.singletonList(this.formRequest);
    }

    @Override
    public Set<MaterialType> getMaterialTypes() {
        return EnumSet.copyOf(Arrays.asList(MaterialType.ORE));
    }

    @Override
    public Set<String> getDefaultMaterialBlacklist() {
        return BLACKLIST;
    }

    @Override
    public void defineMaterialConfig(IModuleData moduleData, Map<IMaterial, IDynamicSpecConfig> configs) {
        this.configs = configs;
    }

    @Override
    public void onInit(IModuleData moduleData, FMLInitializationEvent event) {
        TeslaThingiesHelper helper = TeslaThingiesHelper.INSTANCE;
        MiscHelper miscHelper = MiscHelper.INSTANCE;
        ItemFormType itemFormType = ItemFormType.INSTANCE;
        for (IMaterial material : this.formRequest.getMaterials()) {
            int amount;
            String teslaLumpOredict = miscHelper.getOredictName("teslaLump", material.getName());
            IItemInfo augmentedLumpInfo = itemFormType.getMaterialFormInfo(this.augmentedLumpForm, material);
            String augmentedLumpOredict = miscHelper.getOredictName("augmentedLump", material.getName());
            String dustOredict = miscHelper.getOredictName("dust", material.getName());
            helper.registerCompoundMakerRecipe(miscHelper.getRecipeKey("teslathingies.tesla_lump_to_augmented_lump", material.getName()), new Object[]{teslaLumpOredict, 1}, new Object[]{TeslifiedObsidian.INSTANCE, 1}, augmentedLumpInfo, 1);
            switch (material.getType()) {
                default: {
                    amount = 2;
                    break;
                }
                case GEM: 
                case CRYSTAL: {
                    amount = 3;
                    break;
                }
                case DUST: {
                    amount = 5;
                }
            }
            Object[] output = new Object[]{dustOredict, amount, Float.valueOf(1.0f), dustOredict, 1, Float.valueOf(0.24f)};
            if (material.hasExtra(1)) {
                String extraDustOredict = miscHelper.getOredictName("dust", material.getExtra(1).getName());
                output = ArrayUtils.addAll((Object[])output, (Object[])new Object[]{extraDustOredict, 1, Float.valueOf(0.24f)});
            }
            helper.registerPowderMakerRecipe(miscHelper.getRecipeKey("teslathingies.augmented_lump_to_dust", material.getName()), augmentedLumpOredict, 1, output);
        }
    }

    @Override
    public Map<String, String> getLegacyRemaps() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"teslalump", (Object)"teslathingies_tesla_lump");
        builder.put((Object)"augmentedlump", (Object)"teslathingies_augmented_lump");
        return builder.build();
    }
}

