/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.teslathingies.recipes;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.ndrei.teslapoweredthingies.api.IPoweredRecipe;
import net.ndrei.teslapoweredthingies.machines.compoundmaker.CompoundMakerRecipe;
import net.ndrei.teslapoweredthingies.machines.compoundmaker.CompoundMakerRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeAction;
import thelm.jaopca.utils.MiscHelper;

public class CompoundMakerRecipeAction
implements IRecipeAction {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object[] top;
    public final Object left;
    public final int leftAmount;
    public final Object[] bottom;
    public final Object right;
    public final int rightAmount;
    public final Object output;
    public final int outputCount;

    public CompoundMakerRecipeAction(ResourceLocation key, Object[] top, Object left, int leftAmount, Object output, int outputCount) {
        this(key, top, left, leftAmount, ObjectArrays.EMPTY_ARRAY, null, 0, output, outputCount);
    }

    public CompoundMakerRecipeAction(ResourceLocation key, Object[] top, Object[] bottom, Object output, int outputCount) {
        this(key, top, null, 0, bottom, null, 0, output, outputCount);
    }

    public CompoundMakerRecipeAction(ResourceLocation key, Object[] top, Object left, int leftAmount, Object[] bottom, Object output, int outputCount) {
        this(key, top, left, leftAmount, bottom, null, 0, output, outputCount);
    }

    public CompoundMakerRecipeAction(ResourceLocation key, Object[] top, Object left, int leftAmount, Object[] bottom, Object right, int rightAmount, Object output, int outputCount) {
        this.key = Objects.requireNonNull(key);
        this.top = top;
        this.left = left;
        this.leftAmount = leftAmount;
        this.bottom = bottom;
        this.right = right;
        this.rightAmount = rightAmount;
        this.output = output;
        this.outputCount = outputCount;
    }

    @Override
    public boolean register() {
        ArrayList topInputs = new ArrayList();
        int i = 0;
        while (i < this.top.length) {
            Ingredient ing;
            Object in = this.top[i];
            Integer inc = 1;
            if (++i < this.top.length && this.top[i] instanceof Integer) {
                inc = (Integer)this.top[i];
                ++i;
            }
            if ((ing = MiscHelper.INSTANCE.getIngredient(in)) == null || inc == 0) {
                throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + in);
            }
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            for (ItemStack is : ing.func_193365_a()) {
                list.add(MiscHelper.INSTANCE.resizeItemStack(is, inc));
            }
            topInputs.add(list);
        }
        FluidStack leftStack = MiscHelper.INSTANCE.getFluidStack(this.left, this.leftAmount);
        ArrayList bottomInputs = new ArrayList();
        i = 0;
        while (i < this.bottom.length) {
            Ingredient ing;
            Object in = this.bottom[i];
            Integer inc = 1;
            if (++i < this.bottom.length && this.bottom[i] instanceof Integer) {
                inc = (Integer)this.bottom[i];
                ++i;
            }
            if ((ing = MiscHelper.INSTANCE.getIngredient(in)) == null || inc == 0) {
                throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + in);
            }
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            for (ItemStack is : ing.func_193365_a()) {
                list.add(MiscHelper.INSTANCE.resizeItemStack(is, inc));
            }
            bottomInputs.add(list);
        }
        FluidStack rightStack = MiscHelper.INSTANCE.getFluidStack(this.right, this.rightAmount);
        if (topInputs.isEmpty() && this.left == null && bottomInputs.isEmpty() && this.right == null) {
            throw new IllegalArgumentException("Empty ingredients in recipe " + this.key + ": " + Arrays.deepToString(this.top) + ", " + this.left + ", " + Arrays.deepToString(this.bottom) + ", " + this.right);
        }
        ItemStack stack = MiscHelper.INSTANCE.getItemStack(this.output, this.outputCount);
        if (stack.func_190926_b()) {
            throw new IllegalArgumentException("Empty output in recipe " + this.key + ": " + this.output);
        }
        for (List topInput : Lists.cartesianProduct(topInputs)) {
            for (List bottomInput : Lists.cartesianProduct(bottomInputs)) {
                CompoundMakerRegistry.INSTANCE.addRecipe((IPoweredRecipe)new CompoundMakerRecipe(this.key, stack, leftStack, topInput.toArray(new ItemStack[topInput.size()]), rightStack, bottomInput.toArray(new ItemStack[bottomInput.size()])), true);
            }
        }
        return true;
    }
}

