/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.teslathingies.recipes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.ndrei.teslapoweredthingies.api.IPoweredRecipe;
import net.ndrei.teslapoweredthingies.common.Output;
import net.ndrei.teslapoweredthingies.common.SecondaryOutput;
import net.ndrei.teslapoweredthingies.machines.powdermaker.PowderMakerRecipe;
import net.ndrei.teslapoweredthingies.machines.powdermaker.PowderMakerRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeAction;
import thelm.jaopca.utils.MiscHelper;

public class PowderMakerRecipeAction
implements IRecipeAction {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object input;
    public final int inputCount;
    public final Object[] output;

    public PowderMakerRecipeAction(ResourceLocation key, Object input, int inputCount, Object ... output) {
        this.key = Objects.requireNonNull(key);
        this.input = input;
        this.inputCount = inputCount;
        this.output = output;
    }

    @Override
    public boolean register() {
        Ingredient ing = MiscHelper.INSTANCE.getIngredient(this.input);
        if (ing == null) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.input);
        }
        List ingList = Arrays.stream(ing.func_193365_a()).map(s -> MiscHelper.INSTANCE.resizeItemStack((ItemStack)s, this.inputCount)).collect(Collectors.toList());
        ArrayList<Object> outputs = new ArrayList<Object>();
        int i = 0;
        while (i < this.output.length) {
            ItemStack stack;
            Object out = this.output[i];
            Integer count = 1;
            if (++i < this.output.length && this.output[i] instanceof Integer) {
                count = (Integer)this.output[i];
                ++i;
            }
            Float chance = Float.valueOf(1.0f);
            if (i < this.output.length && this.output[i] instanceof Float) {
                chance = (Float)this.output[i];
                ++i;
            }
            if ((stack = MiscHelper.INSTANCE.getItemStack(out, count)).func_190926_b()) {
                LOGGER.warn("Empty output in recipe {}: {}", (Object)this.key, out);
                continue;
            }
            if (chance.floatValue() == 1.0f) {
                outputs.add(new Output(stack));
                continue;
            }
            outputs.add(new SecondaryOutput(chance.floatValue(), stack));
        }
        if (outputs.isEmpty()) {
            throw new IllegalArgumentException("Empty outputs in recipe " + this.key + ": " + Arrays.deepToString(this.output));
        }
        PowderMakerRegistry.INSTANCE.addRecipe((IPoweredRecipe)new PowderMakerRecipe(this.key, ingList, outputs), true);
        return true;
    }
}

