/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.thaumcraft.recipes;

import java.util.Objects;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.crafting.CrucibleRecipe;
import thelm.jaopca.api.recipes.IRecipeAction;
import thelm.jaopca.compat.thaumcraft.ThaumcraftHelper;
import thelm.jaopca.utils.MiscHelper;

public class CrucibleRecipeAction
implements IRecipeAction {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final String researchReq;
    public final Object input;
    public final Object[] aspects;
    public final Object output;
    public final int count;

    public CrucibleRecipeAction(ResourceLocation key, String researchReq, Object input, Object[] aspects, Object output, int count) {
        this.key = Objects.requireNonNull(key);
        this.researchReq = researchReq;
        this.input = input;
        this.aspects = aspects;
        this.output = output;
        this.count = count;
    }

    @Override
    public boolean register() {
        Ingredient ing = MiscHelper.INSTANCE.getIngredient(this.input);
        if (ing == null) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.input);
        }
        AspectList aspectList = new AspectList();
        int i = 0;
        while (i < this.aspects.length) {
            Aspect aspect;
            Object in = this.aspects[i];
            Integer inc = 1;
            if (++i < this.aspects.length && this.aspects[i] instanceof Integer) {
                inc = (Integer)this.aspects[i];
                ++i;
            }
            if ((aspect = ThaumcraftHelper.INSTANCE.getAspect(in)) == null) {
                throw new IllegalArgumentException("Non-existent aspect in recipe " + this.key + ": " + in);
            }
            aspectList.add(aspect, inc.intValue());
        }
        ItemStack stack = MiscHelper.INSTANCE.getItemStack(this.output, this.count);
        if (stack.func_190926_b()) {
            throw new IllegalArgumentException("Empty output in recipe " + this.key + ": " + this.output);
        }
        ThaumcraftApi.addCrucibleRecipe((ResourceLocation)this.key, (CrucibleRecipe)new CrucibleRecipe(this.researchReq, stack, (Object)ing, aspectList));
        return true;
    }
}

