/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.thaumcraft.recipes;

import java.util.Objects;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thaumcraft.common.lib.utils.Utils;
import thelm.jaopca.api.recipes.IRecipeAction;
import thelm.jaopca.utils.MiscHelper;

public class SpecialMiningRecipeAction
implements IRecipeAction {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object input;
    public final Object output;
    public final int count;
    public final float chance;

    public SpecialMiningRecipeAction(ResourceLocation key, Object input, Object output, int count, float chance) {
        this.key = Objects.requireNonNull(key);
        this.input = input;
        this.output = output;
        this.count = count;
        this.chance = chance;
    }

    @Override
    public boolean register() {
        Ingredient ing = MiscHelper.INSTANCE.getIngredient(this.input);
        if (ing == null) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.input);
        }
        ItemStack stack = MiscHelper.INSTANCE.getItemStack(this.output, this.count);
        if (stack.func_190926_b()) {
            throw new IllegalArgumentException("Empty output in recipe " + this.key + ": " + this.output);
        }
        for (ItemStack in : ing.func_193365_a()) {
            Utils.addSpecialMiningResult((ItemStack)in, (ItemStack)stack, (float)this.chance);
        }
        return true;
    }
}

