/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.custom.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import net.minecraft.item.EnumRarity;
import net.minecraft.util.math.AxisAlignedBB;
import thelm.jaopca.api.blocks.IBlockFormSettings;
import thelm.jaopca.blocks.BlockFormType;
import thelm.jaopca.forms.FormTypeHandler;
import thelm.jaopca.utils.JsonHelper;

public class BlockFormSettingsDeserializer
implements JsonDeserializer<IBlockFormSettings> {
    public static final BlockFormSettingsDeserializer INSTANCE = new BlockFormSettingsDeserializer();

    private BlockFormSettingsDeserializer() {
    }

    public IBlockFormSettings deserialize(JsonElement jsonElement, JsonDeserializationContext context) {
        return this.deserialize(jsonElement, (Type)((Object)IBlockFormSettings.class), context);
    }

    public IBlockFormSettings deserialize(JsonElement jsonElement, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject functionJson;
        JsonHelper helper = JsonHelper.INSTANCE;
        JsonObject json = helper.getJsonObject(jsonElement, "settings");
        IBlockFormSettings settings = BlockFormType.INSTANCE.getNewSettings();
        if (json.has("blockMaterial")) {
            functionJson = helper.getJsonObject(json, "blockMaterial");
            if (!functionJson.has("default")) {
                functionJson.addProperty("default", "iron");
            }
            settings.setMaterialFunction((Function)helper.deserializeType(json, "blockMaterial", context, BlockFormType.MATERIAL_FUNCTION_TYPE));
        }
        if (json.has("soundType")) {
            functionJson = helper.getJsonObject(json, "soundType");
            if (!functionJson.has("default")) {
                functionJson.addProperty("default", "metal");
            }
            settings.setSoundTypeFunction((Function)helper.deserializeType(json, "soundType", context, BlockFormType.SOUND_TYPE_FUNCTION_TYPE));
        }
        if (json.has("lightOpacity")) {
            functionJson = helper.getJsonObject(json, "lightOpacity");
            if (!functionJson.has("default")) {
                functionJson.addProperty("default", (Number)0);
            }
            settings.setLightOpacityFunction((ToIntFunction)helper.deserializeType(json, "lightOpacity", context, FormTypeHandler.INT_FUNCTION_TYPE));
        }
        if (json.has("lightValue")) {
            functionJson = helper.getJsonObject(json, "lightValue");
            if (!functionJson.has("default")) {
                functionJson.addProperty("default", (Number)0);
            }
            settings.setLightValueFunction((ToIntFunction)helper.deserializeType(json, "lightValue", context, FormTypeHandler.INT_FUNCTION_TYPE));
        }
        if (json.has("blockHardness")) {
            functionJson = helper.getJsonObject(json, "blockHardness");
            if (!functionJson.has("default")) {
                functionJson.addProperty("default", (Number)5);
            }
            settings.setBlockHardnessFunction((ToDoubleFunction)helper.deserializeType(json, "blockHardness", context, FormTypeHandler.DOUBLE_FUNCTION_TYPE));
        }
        if (json.has("explosionResistance")) {
            functionJson = helper.getJsonObject(json, "explosionResistance");
            if (!functionJson.has("default")) {
                functionJson.addProperty("default", (Number)6);
            }
            settings.setExplosionResistanceFunction((ToDoubleFunction)helper.deserializeType(json, "explosionResistance", context, FormTypeHandler.DOUBLE_FUNCTION_TYPE));
        }
        if (json.has("slipperiness")) {
            functionJson = helper.getJsonObject(json, "slipperiness");
            if (!functionJson.has("default")) {
                functionJson.addProperty("default", (Number)0.6);
            }
            settings.setSlipperinessFunction((ToDoubleFunction)helper.deserializeType(json, "slipperiness", context, FormTypeHandler.DOUBLE_FUNCTION_TYPE));
        }
        if (json.has("boundingBox")) {
            settings.setBoundingBox((AxisAlignedBB)helper.deserializeType(json, "boundingBox", context, (Type)((Object)AxisAlignedBB.class)));
        }
        if (json.has("harvestTool")) {
            functionJson = helper.getJsonObject(json, "harvestTool");
            if (!functionJson.has("default")) {
                functionJson.addProperty("default", "minecraft:mineable/pickaxe");
            }
            settings.setHarvestToolFunction((Function)helper.deserializeType(json, "harvestTool", context, FormTypeHandler.STRING_FUNCTION_TYPE));
        }
        if (json.has("harvestLevel")) {
            functionJson = helper.getJsonObject(json, "harvestLevel");
            if (!functionJson.has("default")) {
                functionJson.addProperty("default", (Number)-1);
            }
            settings.setHarvestLevelFunction((ToIntFunction)helper.deserializeType(json, "harvestLevel", context, FormTypeHandler.INT_FUNCTION_TYPE));
        }
        if (json.has("flammability")) {
            functionJson = helper.getJsonObject(json, "flammability");
            if (!functionJson.has("default")) {
                functionJson.addProperty("default", (Number)0);
            }
            settings.setFlammabilityFunction((ToIntFunction)helper.deserializeType(json, "flammability", context, FormTypeHandler.INT_FUNCTION_TYPE));
        }
        if (json.has("fireSpreadSpeed")) {
            functionJson = helper.getJsonObject(json, "fireSpreadSpeed");
            if (!functionJson.has("default")) {
                functionJson.addProperty("default", (Number)0);
            }
            settings.setFireSpreadSpeedFunction((ToIntFunction)helper.deserializeType(json, "fireSpreadSpeed", context, FormTypeHandler.INT_FUNCTION_TYPE));
        }
        if (json.has("isFireSource")) {
            functionJson = helper.getJsonObject(json, "isFireSource");
            if (!functionJson.has("default")) {
                functionJson.addProperty("default", Boolean.valueOf(false));
            }
            settings.setIsFireSourceFunction((Predicate)helper.deserializeType(json, "isFireSource", context, FormTypeHandler.PREDICATE_TYPE));
        }
        if (json.has("isBeaconBase")) {
            functionJson = helper.getJsonObject(json, "isBeaconBase");
            if (!functionJson.has("default")) {
                functionJson.addProperty("default", Boolean.valueOf(false));
            }
            settings.setIsBeaconBaseFunction((Predicate)helper.deserializeType(json, "isBeaconBase", context, FormTypeHandler.PREDICATE_TYPE));
        }
        if (json.has("itemStackLimit")) {
            functionJson = helper.getJsonObject(json, "itemStackLimit");
            if (!functionJson.has("default")) {
                functionJson.addProperty("default", (Number)64);
            }
            settings.setItemStackLimitFunction((ToIntFunction)helper.deserializeType(json, "itemStackLimit", context, FormTypeHandler.INT_FUNCTION_TYPE));
        }
        if (json.has("hasEffect")) {
            boolean hasEffect = helper.getBoolean(json, "hasEffect");
            settings.setHasEffectFunction(m -> m.hasEffect() || hasEffect);
        }
        if (json.has("rarity")) {
            EnumRarity rarity = (EnumRarity)helper.deserializeType(json, "rarity", context, (Type)((Object)EnumRarity.class));
            settings.setDisplayRarityFunction(m -> rarity);
        }
        if (json.has("burnTime")) {
            JsonObject functionJson2 = helper.getJsonObject(json, "burnTime");
            if (!functionJson2.has("default")) {
                functionJson2.addProperty("default", (Number)-1);
            }
            settings.setBurnTimeFunction((ToIntFunction)helper.deserializeType(json, "burnTime", context, FormTypeHandler.INT_FUNCTION_TYPE));
        }
        return settings;
    }
}

