/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.custom.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Type;
import java.util.Locale;
import java.util.TreeMap;
import thelm.jaopca.utils.JsonHelper;

public class EnumDeserializer
implements JsonDeserializer<Enum<?>> {
    public static final EnumDeserializer INSTANCE = new EnumDeserializer();

    private EnumDeserializer() {
    }

    public Enum<?> deserialize(JsonElement jsonElement, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonHelper helper = JsonHelper.INSTANCE;
        if (typeOfT instanceof Class && ((Class)typeOfT).isEnum()) {
            if (helper.isString(jsonElement)) {
                TreeMap<String, Enum> stringToEnum = new TreeMap<String, Enum>();
                for (Enum value : (Enum[])((Class)typeOfT).getEnumConstants()) {
                    stringToEnum.put(value.name().toLowerCase(Locale.US), value);
                }
                String valueString = helper.getString(jsonElement, "value");
                Enum value = (Enum)stringToEnum.get(valueString);
                if (value == null) {
                    throw new JsonSyntaxException("Invalid enum " + valueString);
                }
                return value;
            }
            if (helper.isNumber(jsonElement)) {
                Enum[] values;
                int valueOrdinal = helper.getInt(jsonElement, "value");
                if (valueOrdinal >= (values = (Enum[])((Class)typeOfT).getEnumConstants()).length) {
                    throw new JsonSyntaxException("Invalid enum ordinal " + valueOrdinal);
                }
                return values[valueOrdinal];
            }
        }
        throw new JsonParseException("Unable to deserialize " + helper.toSimpleString(jsonElement) + " into an enum");
    }
}

