/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.custom.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import net.minecraft.item.EnumRarity;
import thelm.jaopca.api.fluids.IFluidFormSettings;
import thelm.jaopca.blocks.BlockFormType;
import thelm.jaopca.fluids.FluidFormType;
import thelm.jaopca.forms.FormTypeHandler;
import thelm.jaopca.utils.JsonHelper;

public class FluidFormSettingsDeserializer
implements JsonDeserializer<IFluidFormSettings> {
    public static final FluidFormSettingsDeserializer INSTANCE = new FluidFormSettingsDeserializer();

    private FluidFormSettingsDeserializer() {
    }

    public IFluidFormSettings deserialize(JsonElement jsonElement, JsonDeserializationContext context) {
        return this.deserialize(jsonElement, (Type)((Object)IFluidFormSettings.class), context);
    }

    public IFluidFormSettings deserialize(JsonElement jsonElement, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject functionJson;
        JsonHelper helper = JsonHelper.INSTANCE;
        JsonObject json = helper.getJsonObject(jsonElement, "settings");
        IFluidFormSettings settings = FluidFormType.INSTANCE.getNewSettings();
        if (json.has("fillSound")) {
            settings.setFillSoundSupplier((Supplier)helper.deserializeType(json, "fillSound", context, FluidFormType.SOUND_EVENT_SUPPLIER_TYPE));
        }
        if (json.has("emptySound")) {
            settings.setFillSoundSupplier((Supplier)helper.deserializeType(json, "emptySound", context, FluidFormType.SOUND_EVENT_SUPPLIER_TYPE));
        }
        if (json.has("luminosity")) {
            functionJson = helper.getJsonObject(json, "luminosity");
            if (!functionJson.has("default")) {
                functionJson.addProperty("default", (Number)0);
            }
            settings.setLuminosityFunction((ToIntFunction)helper.deserializeType(json, "luminosity", context, FormTypeHandler.INT_FUNCTION_TYPE));
        }
        if (json.has("density")) {
            functionJson = helper.getJsonObject(json, "density");
            if (!functionJson.has("default")) {
                functionJson.addProperty("default", (Number)1000);
            }
            settings.setDensityFunction((ToIntFunction)helper.deserializeType(json, "density", context, FormTypeHandler.INT_FUNCTION_TYPE));
        }
        if (json.has("temperature")) {
            functionJson = helper.getJsonObject(json, "temperature");
            if (!functionJson.has("default")) {
                functionJson.addProperty("default", (Number)300);
            }
            settings.setTemperatureFunction((ToIntFunction)helper.deserializeType(json, "temperature", context, FormTypeHandler.INT_FUNCTION_TYPE));
        }
        if (json.has("viscosity")) {
            functionJson = helper.getJsonObject(json, "viscosity");
            if (!functionJson.has("default")) {
                functionJson.addProperty("default", (Number)1000);
            }
            settings.setViscosityFunction((ToIntFunction)helper.deserializeType(json, "viscosity", context, FormTypeHandler.INT_FUNCTION_TYPE));
        }
        if (json.has("gaseous")) {
            functionJson = helper.getJsonObject(json, "viscosity");
            if (!functionJson.has("gaseous")) {
                functionJson.addProperty("gaseous", Boolean.valueOf(false));
            }
            settings.setIsGaseousFunction((Predicate)helper.deserializeType(json, "gaseous", context, FormTypeHandler.PREDICATE_TYPE));
        }
        if (json.has("rarity")) {
            EnumRarity rarity = (EnumRarity)helper.deserializeType(json, "rarity", context, (Type)((Object)EnumRarity.class));
            settings.setDisplayRarityFunction(m -> rarity);
        }
        if (json.has("maxLevel")) {
            functionJson = helper.getJsonObject(json, "maxLevel");
            if (!functionJson.has("default")) {
                functionJson.addProperty("default", (Number)8);
            }
            settings.setMaxLevelFunction((ToIntFunction)helper.deserializeType(json, "maxLevel", context, FormTypeHandler.INT_FUNCTION_TYPE));
        }
        if (json.has("blockMaterial")) {
            functionJson = helper.getJsonObject(json, "blockMaterial");
            if (!functionJson.has("default")) {
                functionJson.addProperty("default", "iron");
            }
            settings.setMaterialFunction((Function)helper.deserializeType(json, "blockMaterial", context, BlockFormType.MATERIAL_FUNCTION_TYPE));
        }
        if (json.has("blockHardness")) {
            functionJson = helper.getJsonObject(json, "blockHardness");
            if (!functionJson.has("default")) {
                functionJson.addProperty("default", (Number)5);
            }
            settings.setBlockHardnessFunction((ToDoubleFunction)helper.deserializeType(json, "blockHardness", context, FormTypeHandler.DOUBLE_FUNCTION_TYPE));
        }
        if (json.has("explosionResistance")) {
            functionJson = helper.getJsonObject(json, "explosionResistance");
            if (!functionJson.has("default")) {
                functionJson.addProperty("default", (Number)100);
            }
            settings.setExplosionResistanceFunction((ToDoubleFunction)helper.deserializeType(json, "explosionResistance", context, FormTypeHandler.DOUBLE_FUNCTION_TYPE));
        }
        if (json.has("flammability")) {
            functionJson = helper.getJsonObject(json, "flammability");
            if (!functionJson.has("default")) {
                functionJson.addProperty("default", (Number)0);
            }
            settings.setFlammabilityFunction((ToIntFunction)helper.deserializeType(json, "flammability", context, FormTypeHandler.INT_FUNCTION_TYPE));
        }
        if (json.has("fireSpreadSpeed")) {
            functionJson = helper.getJsonObject(json, "fireSpreadSpeed");
            if (!functionJson.has("default")) {
                functionJson.addProperty("default", (Number)0);
            }
            settings.setFireSpreadSpeedFunction((ToIntFunction)helper.deserializeType(json, "fireSpreadSpeed", context, FormTypeHandler.INT_FUNCTION_TYPE));
        }
        if (json.has("isFireSource")) {
            functionJson = helper.getJsonObject(json, "isFireSource");
            if (!functionJson.has("default")) {
                functionJson.addProperty("default", Boolean.valueOf(false));
            }
            settings.setIsFireSourceFunction((Predicate)helper.deserializeType(json, "isFireSource", context, FormTypeHandler.PREDICATE_TYPE));
        }
        return settings;
    }
}

