/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.fluids;

import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.minecraft.item.EnumRarity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import thelm.jaopca.api.fluids.IFluidFormSettings;
import thelm.jaopca.api.fluids.IMaterialFormFluid;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.functions.MemoizingSuppliers;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;

public class JAOPCAFluid
extends Fluid
implements IMaterialFormFluid {
    private final IForm form;
    private final IMaterial material;
    protected final IFluidFormSettings settings;
    protected Supplier<EnumRarity> rarity;
    protected IntSupplier opacity;
    protected Supplier<String> translationKey;

    public JAOPCAFluid(IForm form, IMaterial material, IFluidFormSettings settings) {
        super(MiscHelper.INSTANCE.getFluidName(form.getSecondaryName(), material.getName()), new ResourceLocation("jaopca", "fluid/" + material.getModelType() + '/' + form.getName() + "_still"), new ResourceLocation("jaopca", "fluid/" + material.getModelType() + '/' + form.getName() + "_flow"));
        this.form = form;
        this.material = material;
        this.settings = settings;
        this.setLuminosity(settings.getLuminosityFunction().applyAsInt(material));
        this.setDensity(settings.getDensityFunction().applyAsInt(material));
        this.setTemperature(settings.getTemperatureFunction().applyAsInt(material));
        this.setViscosity(settings.getViscosityFunction().applyAsInt(material));
        this.setGaseous(settings.getIsGaseousFunction().test(material));
        this.rarity = MemoizingSuppliers.of(settings.getDisplayRarityFunction(), () -> material);
        this.opacity = MemoizingSuppliers.of(settings.getOpacityFunction(), () -> material);
        this.translationKey = MemoizingSuppliers.of(() -> "fluid.jaopca." + MiscHelper.INSTANCE.toLowercaseUnderscore(material.getName()));
    }

    @Override
    public IForm getForm() {
        return this.form;
    }

    @Override
    public IMaterial getMaterial() {
        return this.material;
    }

    public EnumRarity getRarity() {
        return this.rarity.get();
    }

    public SoundEvent getFillSound() {
        return this.settings.getFillSoundSupplier().get();
    }

    public SoundEvent getEmptySound() {
        return this.settings.getEmptySoundSupplier().get();
    }

    public int getOpacity() {
        return this.opacity.getAsInt();
    }

    public int getColor() {
        return this.material.getColor() & 0xFFFFFF | this.getOpacity() << 24;
    }

    public ResourceLocation getStill() {
        if (MiscHelper.INSTANCE.hasResource(new ResourceLocation("jaopca", "textures/fluid/" + this.form.getName() + '.' + this.material.getName() + "_still.png"))) {
            return new ResourceLocation("jaopca", "fluid/" + this.form.getName() + '.' + this.material.getName() + "_still");
        }
        return super.getStill();
    }

    public ResourceLocation getFlowing() {
        if (MiscHelper.INSTANCE.hasResource(new ResourceLocation("jaopca", "textures/fluid/" + this.form.getName() + '.' + this.material.getName() + "_flow.png"))) {
            return new ResourceLocation("jaopca", "fluid/" + this.form.getName() + '.' + this.material.getName() + "_flow");
        }
        return super.getFlowing();
    }

    public String getUnlocalizedName() {
        return this.translationKey.get();
    }

    public String getLocalizedName(FluidStack stack) {
        return ApiImpl.INSTANCE.currentLocalizer().localizeMaterialForm("fluid.jaopca." + this.getForm().getName(), this.getMaterial(), this.getUnlocalizedName());
    }
}

