/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.fluids;

import java.util.function.BooleanSupplier;
import java.util.function.DoubleSupplier;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidClassic;
import thelm.jaopca.api.fluids.IFluidFormSettings;
import thelm.jaopca.api.fluids.IMaterialFormFluid;
import thelm.jaopca.api.fluids.IMaterialFormFluidBlock;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.functions.MemoizingSuppliers;
import thelm.jaopca.api.materials.IMaterial;

public class JAOPCAFluidBlock
extends BlockFluidClassic
implements IMaterialFormFluidBlock {
    private final IMaterialFormFluid fluid;
    protected final IFluidFormSettings settings;
    protected Supplier<Material> blockMaterial;
    protected Supplier<MapColor> mapColor;
    protected DoubleSupplier blockHardness;
    protected DoubleSupplier explosionResistance;
    protected IntSupplier flammability;
    protected IntSupplier fireSpreadSpeed;
    protected BooleanSupplier isFireSource;

    public JAOPCAFluidBlock(IMaterialFormFluid fluid, IFluidFormSettings settings) {
        super(fluid.toFluid(), Material.field_151586_h);
        this.fluid = fluid;
        this.settings = settings;
        this.setQuantaPerBlock(settings.getMaxLevelFunction().applyAsInt(fluid.getMaterial()));
        this.blockMaterial = MemoizingSuppliers.of(settings.getMaterialFunction(), fluid::getMaterial);
        this.mapColor = MemoizingSuppliers.of(settings.getMapColorFunction(), fluid::getMaterial);
        this.blockHardness = MemoizingSuppliers.of(settings.getBlockHardnessFunction(), fluid::getMaterial);
        this.explosionResistance = MemoizingSuppliers.of(settings.getExplosionResistanceFunction(), fluid::getMaterial);
        this.flammability = MemoizingSuppliers.of(settings.getFlammabilityFunction(), fluid::getMaterial);
        this.fireSpreadSpeed = MemoizingSuppliers.of(settings.getFireSpreadSpeedFunction(), fluid::getMaterial);
        this.isFireSource = MemoizingSuppliers.of(settings.getIsFireSourceFunction(), fluid::getMaterial);
    }

    @Override
    public IForm getForm() {
        return this.fluid.getForm();
    }

    @Override
    public IMaterial getMaterial() {
        return this.fluid.getMaterial();
    }

    public Material func_149688_o(IBlockState state) {
        return this.blockMaterial.get();
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return this.mapColor.get();
    }

    public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
        return (float)this.blockHardness.getAsDouble();
    }

    public float func_149638_a(Entity exploder) {
        return (float)this.explosionResistance.getAsDouble();
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.flammability.getAsInt();
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.fireSpreadSpeed.getAsInt();
    }

    public boolean isFireSource(World world, BlockPos pos, EnumFacing side) {
        return this.isFireSource.getAsBoolean();
    }
}

