/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.items;

import java.util.function.BooleanSupplier;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.functions.MemoizingSuppliers;
import thelm.jaopca.api.items.IItemFormSettings;
import thelm.jaopca.api.items.IMaterialFormItem;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.utils.ApiImpl;

public class JAOPCAItem
extends Item
implements IMaterialFormItem {
    private final IForm form;
    private final IMaterial material;
    protected final IItemFormSettings settings;
    protected IntSupplier itemStackLimit;
    protected BooleanSupplier hasEffect;
    protected Supplier<EnumRarity> rarity;
    protected IntSupplier burnTime;
    protected Supplier<String> translationKey;

    public JAOPCAItem(IForm form, IMaterial material, IItemFormSettings settings) {
        this.form = form;
        this.material = material;
        this.settings = settings;
        this.itemStackLimit = MemoizingSuppliers.of(settings.getItemStackLimitFunction(), () -> material);
        this.hasEffect = MemoizingSuppliers.of(settings.getHasEffectFunction(), () -> material);
        this.rarity = MemoizingSuppliers.of(settings.getDisplayRarityFunction(), () -> material);
        this.burnTime = MemoizingSuppliers.of(settings.getBurnTimeFunction(), () -> material);
        this.translationKey = MemoizingSuppliers.of(() -> {
            ResourceLocation id = this.getRegistryName();
            return "item." + id.func_110624_b() + "." + id.func_110623_a().replace('/', '.');
        });
    }

    @Override
    public IForm getForm() {
        return this.form;
    }

    @Override
    public IMaterial getMaterial() {
        return this.material;
    }

    public int getItemStackLimit(ItemStack stack) {
        return this.itemStackLimit.getAsInt();
    }

    public boolean func_77636_d(ItemStack stack) {
        return this.hasEffect.getAsBoolean() || super.func_77636_d(stack);
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return this.rarity.get();
    }

    public int getItemBurnTime(ItemStack itemStack) {
        return this.burnTime.getAsInt();
    }

    public String func_77658_a() {
        return this.translationKey.get();
    }

    public String func_77667_c(ItemStack stack) {
        return this.func_77658_a();
    }

    public String func_77653_i(ItemStack stack) {
        return ApiImpl.INSTANCE.currentLocalizer().localizeMaterialForm("item.jaopca." + this.getForm().getName(), this.getMaterial(), this.func_77667_c(stack));
    }
}

