/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.localization;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.util.text.translation.I18n;
import org.apache.commons.lang3.StringUtils;
import thelm.jaopca.api.localization.ILocalizer;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.utils.ApiImpl;

public class LocalizerDefault
implements ILocalizer {
    public static final LocalizerDefault INSTANCE = new LocalizerDefault();

    private LocalizerDefault() {
    }

    @Override
    public String localizeMaterialForm(String formTranslationKey, IMaterial material, String overrideKey) {
        Map<String, String> locMap = ApiImpl.INSTANCE.currentMaterialLocalizationMap();
        if (I18n.func_94522_b((String)overrideKey)) {
            return I18n.func_74838_a((String)overrideKey);
        }
        if (locMap.containsKey(overrideKey)) {
            return locMap.get(overrideKey);
        }
        String materialKey = "jaopca.material." + material.getName();
        String materialName = I18n.func_94522_b((String)materialKey) ? I18n.func_74838_a((String)materialKey) : (locMap.containsKey(materialKey) ? locMap.get(materialKey) : LocalizerDefault.splitAndCapitalize(material.getName()));
        if (I18n.func_94522_b((String)formTranslationKey) || !locMap.containsKey(formTranslationKey)) {
            return I18n.func_74837_a((String)formTranslationKey, (Object[])new Object[]{materialName});
        }
        return String.format(locMap.get(overrideKey), materialName);
    }

    public static String splitAndCapitalize(String camelCase) {
        return Arrays.stream(StringUtils.splitByCharacterTypeCamelCase((String)camelCase)).map(StringUtils::capitalize).collect(Collectors.joining(" "));
    }
}

