/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.materials;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.item.EnumRarity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.config.FormattedNumber;
import thelm.jaopca.api.config.IDynamicSpecConfig;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialColorEvent;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.client.colors.ColorHandler;
import thelm.jaopca.config.ConfigHandler;
import thelm.jaopca.materials.MaterialHandler;
import thelm.jaopca.utils.MiscHelper;

public class Material
implements IMaterial {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Set<String> DEFAULT_SMALL_BLOCKS = new TreeSet<String>(Arrays.asList("Quartz", "QuartzBlack"));
    private final String name;
    private final MaterialType type;
    private String modelType;
    private final TreeSet<String> alternativeNames = new TreeSet();
    private OptionalInt color = OptionalInt.empty();
    private boolean hasEffect = false;
    private EnumRarity displayRarity = EnumRarity.COMMON;
    private final List<String> extras = new ArrayList<String>();
    private final TreeSet<String> configModuleBlacklist = new TreeSet();
    private boolean isSmallStorageBlock;
    private IDynamicSpecConfig config;
    private String oredict;
    private boolean shouldFireColorEvent = true;

    public Material(String name, MaterialType type) {
        this.name = name;
        this.type = type;
        this.isSmallStorageBlock = DEFAULT_SMALL_BLOCKS.contains(name);
        switch (type) {
            case INGOT: 
            case INGOT_PLAIN: {
                this.modelType = "metallic";
                break;
            }
            case GEM: 
            case GEM_PLAIN: 
            case CRYSTAL: 
            case CRYSTAL_PLAIN: {
                this.modelType = "crystal";
                break;
            }
            case DUST: 
            case DUST_PLAIN: {
                this.modelType = "dust";
            }
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public MaterialType getType() {
        return this.type;
    }

    @Override
    public Set<String> getAlternativeNames() {
        return Collections.unmodifiableNavigableSet(this.alternativeNames);
    }

    @Override
    public IMaterial getExtra(int index) {
        return index == 0 || !this.hasExtra(index) ? this : (IMaterial)Optional.ofNullable(MaterialHandler.getMaterial(this.extras.get(index - 1))).orElse(this);
    }

    @Override
    public boolean hasExtra(int index) {
        return index == 0 || index - 1 < this.extras.size() && !StringUtils.isEmpty((CharSequence)this.extras.get(index - 1));
    }

    @Override
    public boolean isSmallStorageBlock() {
        return this.isSmallStorageBlock;
    }

    @Override
    public Set<String> getConfigModuleBlacklist() {
        return Collections.unmodifiableNavigableSet(this.configModuleBlacklist);
    }

    @Override
    public String getModelType() {
        return this.modelType;
    }

    @Override
    public int getColor() {
        if (Loader.instance().hasReachedState(LoaderState.POSTINITIALIZATION)) {
            if (!this.color.isPresent() && this.config != null) {
                MiscHelper.INSTANCE.conditionalRunnable(() -> ((Side)FMLCommonHandler.instance().getSide()).isClient(), () -> () -> {
                    this.shouldFireColorEvent = false;
                    String oredict = this.getOredict();
                    this.color = OptionalInt.of(0xFFFFFF);
                    MiscHelper.INSTANCE.submitAsyncTask(() -> {
                        try {
                            int averageColor = ColorHandler.getAverageColor(oredict);
                            int configColor = this.config.getDefinedNumber("general.color", (Number)new FormattedNumber("0x%06X", (Number)averageColor), "The color of this material.").intValue();
                            this.color = OptionalInt.of(configColor);
                            MinecraftForge.EVENT_BUS.post((Event)new MaterialColorEvent(this, configColor));
                        }
                        catch (Exception e) {
                            LOGGER.warn("Unable to get color for material {}", (Object)this.name, (Object)e);
                        }
                    });
                }, () -> () -> {}).run();
            }
            if (this.color.isPresent() && this.shouldFireColorEvent) {
                this.shouldFireColorEvent = false;
                MinecraftForge.EVENT_BUS.post((Event)new MaterialColorEvent(this, this.color.getAsInt()));
            }
        } else {
            LOGGER.warn("Tried to get color for material {} before post-init", (Object)this.name);
        }
        return 0xFF000000 | this.color.orElse(0xFFFFFF);
    }

    @Override
    public boolean hasEffect() {
        return this.hasEffect;
    }

    @Override
    public EnumRarity getDisplayRarity() {
        return this.displayRarity;
    }

    public void setAlternativeNames(Collection<String> names) {
        this.alternativeNames.addAll(names);
    }

    public void setConfig(IDynamicSpecConfig config) {
        this.config = config;
        config.setComment("general", "Configurations for material " + this.name + ".");
        List<String> cfgList = config.getDefinedStringList("general.alternativeNames", new ArrayList<String>(this.alternativeNames), "The alternative names of this material.");
        this.alternativeNames.clear();
        this.alternativeNames.addAll(cfgList);
        cfgList = config.getDefinedStringList("general.extras", this.extras, MaterialHandler::containsMaterial, "The byproducts of this material.");
        this.extras.clear();
        this.extras.addAll(cfgList);
        this.isSmallStorageBlock = config.getDefinedBoolean("general.isSmallStorageBlock", this.isSmallStorageBlock, "Is the storage block of this material small (2x2).");
        MiscHelper helper = MiscHelper.INSTANCE;
        helper.caclulateModuleSet(config.getDefinedStringList("general.moduleBlacklist", new ArrayList<String>(this.configModuleBlacklist), helper.configModulePredicate(), "The module blacklist of this material. \"*\" is an alias for all modules. If a module name occurs an odd number of times (including wildcards), then the module is blacklisted."), this.configModuleBlacklist);
        this.hasEffect = config.getDefinedBoolean("general.hasEffect", this.hasEffect, "Should items of this material have the enchanted glow.");
        this.modelType = config.getDefinedString("general.modelType", this.modelType, s -> Material.isModelTypeValid(s), "The model type of the material.");
        if (ConfigHandler.resetColors) {
            config.remove("general.color");
        }
        this.color = config.getOptionalInt("general.color");
    }

    private String getOredict() {
        if (this.oredict == null) {
            this.oredict = this.type.getFormName() + this.name;
        }
        return this.oredict;
    }

    public String toString() {
        return "Material:" + this.name;
    }

    private static boolean isModelTypeValid(String modelType) {
        return modelType.chars().allMatch(c -> c == 95 || c == 45 || c >= 97 && c <= 122 || c >= 48 && c <= 57 || c == 47 || c == 46);
    }
}

