/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.materials;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.config.ConfigHandler;
import thelm.jaopca.materials.Material;
import thelm.jaopca.utils.ApiImpl;

public class MaterialHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final TreeSet<String> BLACKLISTED_NAMES = new TreeSet();
    private static final TreeSet<String> USED_PREFIXES = new TreeSet<String>(Arrays.asList("ingotAny", "ingotHot", "ingotDouble", "ingotTriple", "ingotQuadruple", "ingotQuintuple", "gemAny", "gemOre", "gemRaw", "gemUncut", "gemPolished", "gemChipped", "gemFlawed", "gemFlawless", "gemExquisite", "gemLegendary", "crystalAny", "crystalFragment", "crystalShard", "crystalCluster", "crystalPure", "dustAny", "dustSmall", "dustTiny", "dustDirty", "dustDiv72", "dustImpure", "dustPure", "dustRefined", "dustRegular"));
    private static final ListMultimap<String, String> ALTERNATIVE_NAMES = MultimapBuilder.treeKeys().arrayListValues().build();
    private static final TreeMap<String, Material> MATERIALS = new TreeMap();

    private MaterialHandler() {
    }

    public static Map<String, Material> getMaterialMap() {
        return MATERIALS;
    }

    public static Collection<Material> getMaterials() {
        return MATERIALS.values();
    }

    public static Material getMaterial(String name) {
        return MATERIALS.get(name);
    }

    public static boolean containsMaterial(String name) {
        return MATERIALS.containsKey(name);
    }

    public static boolean registerBlacklistedMaterialNames(String ... names) {
        return Collections.addAll(BLACKLISTED_NAMES, names);
    }

    public static boolean registerUsedPlainPrefixes(String ... prefixes) {
        return Collections.addAll(USED_PREFIXES, prefixes);
    }

    public static boolean registerMaterialAlternativeNames(String name, String ... alternatives) {
        return ALTERNATIVE_NAMES.putAll((Object)name, Arrays.asList(alternatives));
    }

    public static void findMaterials() {
        Material material;
        MATERIALS.clear();
        Set<String> oredict = ApiImpl.INSTANCE.getOredict();
        TreeSet allMaterials = new TreeSet();
        TreeSet<String> nameBlacklist = new TreeSet<String>();
        Set<String> nonPlainPrefixes = ConfigHandler.nonPlainUsedPrefix ? USED_PREFIXES : Collections.emptySet();
        nameBlacklist.addAll(BLACKLISTED_NAMES);
        nameBlacklist.addAll(ConfigHandler.GEM_OVERRIDES);
        nameBlacklist.addAll(ConfigHandler.CRYSTAL_OVERRIDES);
        nameBlacklist.addAll(ConfigHandler.DUST_OVERRIDES);
        LinkedHashSet ingots = ConfigHandler.ingot ? MaterialHandler.find(oredict, nameBlacklist, nonPlainPrefixes, "ingot", "ore") : new LinkedHashSet();
        nameBlacklist.clear();
        allMaterials.addAll(ingots);
        nameBlacklist.addAll(allMaterials);
        nameBlacklist.addAll(BLACKLISTED_NAMES);
        nameBlacklist.addAll(ConfigHandler.CRYSTAL_OVERRIDES);
        nameBlacklist.addAll(ConfigHandler.DUST_OVERRIDES);
        LinkedHashSet gems = ConfigHandler.gem ? MaterialHandler.find(oredict, nameBlacklist, nonPlainPrefixes, "gem", "ore") : new LinkedHashSet();
        nameBlacklist.clear();
        allMaterials.addAll(gems);
        nameBlacklist.addAll(allMaterials);
        nameBlacklist.addAll(BLACKLISTED_NAMES);
        nameBlacklist.addAll(ConfigHandler.DUST_OVERRIDES);
        LinkedHashSet crystals = ConfigHandler.crystal ? MaterialHandler.find(oredict, nameBlacklist, nonPlainPrefixes, "crystal", "ore") : new LinkedHashSet();
        nameBlacklist.clear();
        allMaterials.addAll(crystals);
        nameBlacklist.addAll(allMaterials);
        nameBlacklist.addAll(BLACKLISTED_NAMES);
        LinkedHashSet dusts = ConfigHandler.dust ? MaterialHandler.find(oredict, nameBlacklist, nonPlainPrefixes, "dust", "ore") : new LinkedHashSet();
        nameBlacklist.clear();
        allMaterials.addAll(dusts);
        nameBlacklist.addAll(allMaterials);
        nameBlacklist.addAll(BLACKLISTED_NAMES);
        nameBlacklist.addAll(ConfigHandler.GEM_OVERRIDES);
        nameBlacklist.addAll(ConfigHandler.CRYSTAL_OVERRIDES);
        nameBlacklist.addAll(ConfigHandler.DUST_OVERRIDES);
        LinkedHashSet ingotsPlain = ConfigHandler.ingotPlain ? MaterialHandler.find(oredict, nameBlacklist, USED_PREFIXES, "ingot", new String[0]) : new LinkedHashSet();
        nameBlacklist.clear();
        allMaterials.addAll(ingotsPlain);
        nameBlacklist.addAll(allMaterials);
        nameBlacklist.addAll(BLACKLISTED_NAMES);
        nameBlacklist.addAll(ConfigHandler.CRYSTAL_OVERRIDES);
        nameBlacklist.addAll(ConfigHandler.DUST_OVERRIDES);
        LinkedHashSet gemsPlain = ConfigHandler.gemPlain ? MaterialHandler.find(oredict, nameBlacklist, USED_PREFIXES, "gem", new String[0]) : new LinkedHashSet();
        nameBlacklist.clear();
        allMaterials.addAll(gemsPlain);
        nameBlacklist.addAll(allMaterials);
        nameBlacklist.addAll(BLACKLISTED_NAMES);
        nameBlacklist.addAll(ConfigHandler.DUST_OVERRIDES);
        LinkedHashSet crystalsPlain = ConfigHandler.crystalPlain ? MaterialHandler.find(oredict, nameBlacklist, USED_PREFIXES, "crystal", new String[0]) : new LinkedHashSet();
        nameBlacklist.clear();
        allMaterials.addAll(crystalsPlain);
        nameBlacklist.addAll(allMaterials);
        nameBlacklist.addAll(BLACKLISTED_NAMES);
        LinkedHashSet dustsPlain = ConfigHandler.dustPlain ? MaterialHandler.find(oredict, nameBlacklist, USED_PREFIXES, "dust", new String[0]) : new LinkedHashSet();
        nameBlacklist.clear();
        allMaterials.addAll(dustsPlain);
        for (String name : ingots) {
            material = new Material(name, MaterialType.INGOT);
            MATERIALS.put(name, material);
            LOGGER.debug("Added ingot material {}", (Object)name);
        }
        for (String name : gems) {
            material = new Material(name, MaterialType.GEM);
            MATERIALS.put(name, material);
            LOGGER.debug("Added gem material {}", (Object)name);
        }
        for (String name : crystals) {
            material = new Material(name, MaterialType.CRYSTAL);
            MATERIALS.put(name, material);
            LOGGER.debug("Added crystal material {}", (Object)name);
        }
        for (String name : dusts) {
            material = new Material(name, MaterialType.DUST);
            MATERIALS.put(name, material);
            LOGGER.debug("Added dust material {}", (Object)name);
        }
        for (String name : ingotsPlain) {
            material = new Material(name, MaterialType.INGOT_PLAIN);
            MATERIALS.put(name, material);
            LOGGER.debug("Added plain ingot material {}", (Object)name);
        }
        for (String name : gemsPlain) {
            material = new Material(name, MaterialType.GEM_PLAIN);
            MATERIALS.put(name, material);
            LOGGER.debug("Added plain gem material {}", (Object)name);
        }
        for (String name : crystalsPlain) {
            material = new Material(name, MaterialType.CRYSTAL_PLAIN);
            MATERIALS.put(name, material);
            LOGGER.debug("Added plain crystal material {}", (Object)name);
        }
        for (String name : dustsPlain) {
            material = new Material(name, MaterialType.DUST_PLAIN);
            MATERIALS.put(name, material);
            LOGGER.debug("Added plain dust material {}", (Object)name);
        }
        LOGGER.info("Added {} materials", (Object)MATERIALS.size());
    }

    protected static Set<String> find(Set<String> entries, Set<String> nameBlacklist, Set<String> prefixBlacklist, String mainPrefix, String ... prefixes) {
        TreeSet<String> found = new TreeSet<String>();
        for (String entry : entries) {
            String name;
            if (!entry.startsWith(mainPrefix) || (name = entry.substring(mainPrefix.length())).isEmpty() || Character.isLowerCase(name.charAt(0)) || nameBlacklist.contains(name)) continue;
            if (!Arrays.stream(prefixes).map(prefix -> prefix + name).allMatch(entries::contains)) continue;
            found.add(name);
        }
        TreeSet<String> ret = new TreeSet<String>();
        for (String name : found) {
            String entry = mainPrefix + name;
            if (!prefixBlacklist.stream().noneMatch(bp -> {
                if (entry.startsWith((String)bp)) {
                    String nName = entry.substring(bp.length());
                    return ConfigHandler.strictUsedPrefix || found.contains(nName) || nameBlacklist.contains(nName);
                }
                return false;
            })) continue;
            ret.add(name);
        }
        return ret;
    }
}

