/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.modules;

import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Ordering;
import it.unimi.dsi.fastutil.objects.Object2BooleanRBTreeMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.tuple.Pair;
import thelm.jaopca.api.config.IDynamicSpecConfig;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.materials.MaterialHandler;
import thelm.jaopca.modules.ModuleHandler;
import thelm.jaopca.utils.MiscHelper;

public class ModuleData
implements IModuleData {
    private final IModule module;
    private IDynamicSpecConfig config = null;
    private final TreeSet<String> configMaterialBlacklist = new TreeSet();
    private final TreeSet<String> configPassiveMaterialWhitelist = new TreeSet();
    private final Object2BooleanRBTreeMap<IMaterial> dependencyValidMaterials = new Object2BooleanRBTreeMap();
    private final TreeSet<IMaterial> rejectedMaterials = new TreeSet();
    private final TreeSet<IMaterial> requestedMaterials = new TreeSet();
    private final TreeSet<IMaterial> materials = new TreeSet();

    public ModuleData(IModule module) {
        this.module = module;
    }

    @Override
    public IModule getModule() {
        return this.module;
    }

    @Override
    public Set<String> getConfigMaterialBlacklist() {
        return Collections.unmodifiableNavigableSet(this.configMaterialBlacklist);
    }

    @Override
    public Set<String> getConfigPassiveMaterialWhitelist() {
        if (this.module.isPassive()) {
            return Collections.unmodifiableNavigableSet(this.configPassiveMaterialWhitelist);
        }
        return (Set)MaterialHandler.getMaterials().stream().map(IMaterial::getName).collect(ImmutableSortedSet.toImmutableSortedSet((Comparator)Ordering.natural()));
    }

    @Override
    public Set<IMaterial> getMaterials() {
        return Collections.unmodifiableNavigableSet(this.materials);
    }

    public void setConfig(IDynamicSpecConfig config) {
        this.config = config;
        MiscHelper helper = MiscHelper.INSTANCE;
        helper.caclulateMaterialSet(config.getDefinedStringList("general.materialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The material blacklist of this module. \"*\" is an alias for all materials, and \"*\" followed with a material type name is an alias for all materials of that material type. If a material name occurs an odd number of times (including wildcards), then the material is blacklisted. These rules applies to all config material blacklists."), this.configMaterialBlacklist);
        if (this.module.isPassive()) {
            helper.caclulateMaterialSet(config.getDefinedStringList("general.passiveMaterialWhitelist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials to force generate passive forms for this module. \"*\" is an alias for all materials, and \"*\" followed with a material type name is an alias for all materials of that material type. If a material name occurs an odd number of times (including wildcards), then the material is whitelisted. These rules apply to all config material whitelists."), this.configPassiveMaterialWhitelist);
        }
    }

    public boolean isMaterialConfigValid(IMaterial material) {
        return !material.getConfigModuleBlacklist().contains(this.module.getName()) && !this.configMaterialBlacklist.contains(material.getName());
    }

    public boolean isMaterialDependencyValid(IMaterial material, Set<Pair<ModuleData, IMaterial>> prev) {
        return (Boolean)this.dependencyValidMaterials.computeIfAbsent((Object)material, mat -> {
            if (prev.contains(Pair.of((Object)this, (Object)mat))) {
                return true;
            }
            if (!this.isMaterialConfigValid((IMaterial)mat)) {
                return false;
            }
            prev.add(Pair.of((Object)this, (Object)mat));
            for (Map.Entry entry : this.module.getModuleDependencies().asMap().entrySet()) {
                IMaterial extraMaterial = mat.getExtra((Integer)entry.getKey());
                for (String requestedModule : (Collection)entry.getValue()) {
                    ModuleData requestedData = ModuleHandler.getModuleData(requestedModule);
                    if (requestedData != null && requestedData.isMaterialDependencyValid(extraMaterial, prev)) continue;
                    return false;
                }
            }
            return true;
        });
    }

    public boolean isMaterialModuleValid(IMaterial material) {
        return this.isMaterialDependencyValid(material, new HashSet<Pair<ModuleData, IMaterial>>()) && this.module.getMaterialTypes().contains((Object)material.getType()) && !this.module.getDefaultMaterialBlacklist().contains(material.getName());
    }

    public boolean isMaterialValid(IMaterial material) {
        return this.isMaterialModuleValid(material) && !this.rejectedMaterials.contains(material) && (!this.module.isPassive() || this.configPassiveMaterialWhitelist.contains(material.getName()) || this.requestedMaterials.contains(material));
    }

    public void addRejectedMaterial(IMaterial material) {
        this.rejectedMaterials.add(material);
    }

    public void addDependencyRequestedMaterial(IMaterial material) {
        for (Map.Entry entry : this.module.getModuleDependencies().asMap().entrySet()) {
            IMaterial extraMaterial = material.getExtra((Integer)entry.getKey());
            for (String requestedModule : (Collection)entry.getValue()) {
                ModuleData requestedData = ModuleHandler.getModuleData(requestedModule);
                if (requestedData == null || !requestedData.isMaterialDependencyValid(extraMaterial, new HashSet<Pair<ModuleData, IMaterial>>())) {
                    throw new IllegalStateException("Module " + this.module.getName() + " has wrongly accepted material " + material.getName());
                }
                requestedData.addRequestedMaterial(extraMaterial);
            }
        }
    }

    public void addRequestedMaterial(IMaterial material) {
        if (this.getModule().isPassive()) {
            this.requestedMaterials.add(material);
            this.addDependencyRequestedMaterial(material);
        }
    }

    public Set<IMaterial> getRejectedMaterials() {
        return this.rejectedMaterials;
    }

    public Set<IMaterial> getRequestedMaterials() {
        return this.requestedMaterials;
    }

    public void setMaterials(Collection<IMaterial> materials) {
        this.materials.clear();
        this.materials.addAll(materials);
    }
}

