/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.oredict;

import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.oredict.IOredictModule;
import thelm.jaopca.api.oredict.JAOPCAOredictModule;
import thelm.jaopca.config.ConfigHandler;
import thelm.jaopca.utils.MiscHelper;

public class OredictHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String JAOPCA_OREDICT_MODULE = JAOPCAOredictModule.class.getCanonicalName();
    private static final TreeMap<String, IOredictModule> OREDICT_MODULES = new TreeMap();
    private static final TreeSet<String> OREDICT_NAMES = new TreeSet();
    private static boolean initialized = false;

    public static void initialize() {
        initialized = true;
        Arrays.stream(OreDictionary.getOreNames()).filter(name -> !OreDictionary.getOres((String)name, (boolean)false).isEmpty()).forEach(OREDICT_NAMES::add);
    }

    public static void onOreRegister(OreDictionary.OreRegisterEvent event) {
        if (!initialized) {
            OredictHandler.initialize();
        }
        OREDICT_NAMES.add(event.getName());
    }

    public static Set<String> getOredict() {
        if (!initialized) {
            OredictHandler.initialize();
        }
        return OREDICT_NAMES;
    }

    public static Collection<IOredictModule> getOredictModules() {
        return OREDICT_MODULES.values();
    }

    public static void findOredictModules(ASMDataTable asmDataTable) {
        OREDICT_MODULES.clear();
        Set annotationData = asmDataTable.getAll(JAOPCA_OREDICT_MODULE);
        Predicate<String> modVersionNotLoaded = MiscHelper.INSTANCE.modVersionNotLoaded(LOGGER);
        Predicate<String> classNotExists = MiscHelper.INSTANCE::classNotExists;
        for (ASMDataTable.ASMData aData : annotationData) {
            List modDeps = (List)aData.getAnnotationInfo().get("modDependencies");
            List classDeps = (List)aData.getAnnotationInfo().get("classDependencies");
            String className = aData.getClassName();
            if (modDeps != null && modDeps.stream().filter(Predicates.notNull()).anyMatch(modVersionNotLoaded)) {
                LOGGER.info("Oredict module {} has missing mod dependencies, skipping", (Object)className);
                continue;
            }
            if (classDeps != null && classDeps.stream().filter(Predicates.notNull()).anyMatch(classNotExists)) {
                LOGGER.info("Oredict module {} has missing class dependencies, skipping", (Object)className);
                continue;
            }
            try {
                IOredictModule module;
                Class<?> moduleClass = Class.forName(className);
                Class<IOredictModule> moduleInstanceClass = moduleClass.asSubclass(IOredictModule.class);
                try {
                    Method method = moduleClass.getMethod("getInstance", new Class[0]);
                    module = (IOredictModule)method.invoke(null, new Object[0]);
                }
                catch (NoSuchMethodException | InvocationTargetException e) {
                    module = moduleInstanceClass.newInstance();
                }
                if (ConfigHandler.OREDICT_MODULE_BLACKLIST.contains(module.getName())) {
                    LOGGER.info("Oredict module {} is disabled in config, skipping", (Object)module.getName());
                }
                if (OREDICT_MODULES.putIfAbsent(module.getName(), module) != null) {
                    LOGGER.fatal("Oredict module name conflict: {} for {} and {}", (Object)module.getName(), OREDICT_MODULES.get(module.getName()).getClass(), module.getClass());
                    continue;
                }
                LOGGER.debug("Loaded oredict module {}", (Object)module.getName());
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                LOGGER.fatal("Unable to load oredict module {}", (Object)className, (Object)e);
            }
        }
    }

    public static void register() {
        for (IOredictModule module : OredictHandler.getOredictModules()) {
            module.register();
        }
        Splitter lineSplitter = Splitter.on((char)',').omitEmptyStrings().trimResults();
        Splitter oredictSplitter = Splitter.on((char)'=').limit(2).trimResults();
        for (String line : ConfigHandler.CUSTOM_OREDICT) {
            for (String entry : lineSplitter.split((CharSequence)line)) {
                List split = oredictSplitter.splitToList((CharSequence)entry);
                if (split.size() != 2) {
                    LOGGER.warn("Custom oredict entry [{}] has no specified name", (Object)entry);
                    continue;
                }
                ItemStack stack = MiscHelper.INSTANCE.parseMetaItem((String)split.get(0));
                if (stack.func_190926_b()) {
                    LOGGER.warn("Custom oredict entry [{}] has empty item", (Object)entry);
                    continue;
                }
                OreDictionary.registerOre((String)((String)split.get(1)), (ItemStack)stack);
                LOGGER.info("Registered custom oredict entry [{}]", (Object)entry);
            }
        }
    }
}

