/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.registries;

import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.TreeMultimap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.materials.MaterialHandler;
import thelm.jaopca.modules.ModuleHandler;
import thelm.jaopca.utils.MiscHelper;

public class RegistryHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Multimap<String, String> LEGACY_REMAPS = TreeMultimap.create();
    private static boolean initializedRemaps = false;

    private RegistryHandler() {
    }

    public static void initializeRemaps() {
        initializedRemaps = true;
        for (IModule module : ModuleHandler.getModules()) {
            LEGACY_REMAPS.putAll((Multimap)Multimaps.forMap(module.getLegacyRemaps()));
        }
    }

    public static <T extends IForgeRegistryEntry<T>> void onMissingMappings(RegistryEvent.MissingMappings<T> event) {
        if (!initializedRemaps) {
            RegistryHandler.initializeRemaps();
        }
        block0: for (RegistryEvent.MissingMappings.Mapping mapping : event.getMappings()) {
            LOGGER.debug("Remapping registry entry {}", (Object)mapping.key);
            String[] names = mapping.key.func_110623_a().split("_", 2);
            if (names.length == 2) {
                for (Map.Entry remap : LEGACY_REMAPS.entries()) {
                    if (!names[1].startsWith((String)remap.getKey())) continue;
                    String materialName = names[1].substring(((String)remap.getKey()).length());
                    LOGGER.debug("Checking material {}", (Object)materialName);
                    List materials = MaterialHandler.getMaterials().stream().filter(m -> m.getName().equalsIgnoreCase(materialName)).collect(Collectors.toList());
                    for (IMaterial material : materials) {
                        String path = (String)remap.getValue() + '.' + MiscHelper.INSTANCE.toLowercaseUnderscore(material.getName());
                        ResourceLocation remapLocation = new ResourceLocation(mapping.key.func_110624_b(), path);
                        ForgeRegistry reg = RegistryManager.ACTIVE.getRegistry(event.getName());
                        LOGGER.debug("Checking registry entry {}", (Object)remapLocation);
                        if (!reg.containsKey(remapLocation)) continue;
                        mapping.remap(reg.getValue(remapLocation));
                        LOGGER.debug("Remapped registry entry {} to {}", (Object)mapping.key, (Object)remapLocation);
                        continue block0;
                    }
                }
            }
            if ((names = mapping.key.func_110623_a().split("\\.", 2)).length == 2) {
                String materialName = names[1].replaceAll("_", "");
                LOGGER.debug("Checking material {}", (Object)materialName);
                List materials = MaterialHandler.getMaterials().stream().filter(m -> m.getName().equalsIgnoreCase(materialName)).collect(Collectors.toList());
                for (IMaterial material : materials) {
                    String path = names[0] + '.' + MiscHelper.INSTANCE.toLowercaseUnderscore(material.getName());
                    ResourceLocation remapLocation = new ResourceLocation(mapping.key.func_110624_b(), path);
                    ForgeRegistry reg = RegistryManager.ACTIVE.getRegistry(event.getName());
                    LOGGER.debug("Checking registry entry {}", (Object)remapLocation);
                    if (!reg.containsKey(remapLocation)) continue;
                    mapping.remap(reg.getValue(remapLocation));
                    LOGGER.debug("Remapped registry entry {} to {}", (Object)mapping.key, (Object)remapLocation);
                    continue block0;
                }
            }
            LOGGER.debug("Could not remap registry entry {}", (Object)mapping.key);
        }
    }
}

